/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.classpath;

import java.io.IOException;
import org.pitest.classinfo.ClassByteArraySource;
import org.pitest.classpath.ClassPath;
import org.pitest.classpath.OtherClassLoaderClassPathRoot;
import org.pitest.functional.Option;
import org.pitest.util.IsolationUtils;
import org.pitest.util.Unchecked;

public class ClassloaderByteArraySource
implements ClassByteArraySource {
    private final ClassPath cp;

    public ClassloaderByteArraySource(ClassLoader loader) {
        this.cp = new ClassPath(new OtherClassLoaderClassPathRoot(loader));
    }

    public static ClassloaderByteArraySource fromContext() {
        return new ClassloaderByteArraySource(IsolationUtils.getContextClassLoader());
    }

    @Override
    public Option<byte[]> getBytes(String classname) {
        try {
            return Option.some(this.cp.getClassData(classname));
        }
        catch (IOException ex) {
            throw Unchecked.translateCheckedException(ex);
        }
    }
}

