/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.coverage;

import org.pitest.classinfo.BridgeMethodFilter;
import org.pitest.classinfo.MethodFilteringAdapter;
import org.pitest.coverage.analysis.CoverageAnalyser;
import org.pitest.reloc.asm.ClassWriter;
import org.pitest.reloc.asm.MethodVisitor;
import sun.pitest.CodeCoverageStore;

public class CoverageClassVisitor
extends MethodFilteringAdapter {
    private final int classId;
    private int probeCount = 0;

    public CoverageClassVisitor(int classId, ClassWriter writer) {
        super(writer, BridgeMethodFilter.INSTANCE);
        this.classId = classId;
    }

    public void registerProbes(int number) {
        this.probeCount += number;
    }

    @Override
    public MethodVisitor visitMethodIfRequired(int access, String name, String desc, String signature, String[] exceptions, MethodVisitor methodVisitor) {
        return new CoverageAnalyser(this, this.classId, this.probeCount, methodVisitor, access, name, desc, signature, exceptions);
    }

    @Override
    public void visitEnd() {
        CodeCoverageStore.registerClassProbes(this.classId, this.probeCount);
    }
}

