/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.coverage;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.pitest.bytecode.FrameOptions;
import org.pitest.classinfo.ComputeClassWriter;
import org.pitest.classpath.ClassloaderByteArraySource;
import org.pitest.coverage.CoverageClassVisitor;
import org.pitest.functional.predicate.Predicate;
import org.pitest.reloc.asm.ClassReader;
import sun.pitest.CodeCoverageStore;

public class CoverageTransformer
implements ClassFileTransformer {
    private final Predicate<String> filter;
    private final Map<String, String> computeCache = new ConcurrentHashMap<String, String>();

    public CoverageTransformer(Predicate<String> filter) {
        this.filter = filter;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        boolean include = this.shouldInclude(className);
        if (include) {
            try {
                return this.transformBytes(this.pickLoader(loader), className, classfileBuffer);
            }
            catch (RuntimeException t) {
                System.err.println("RuntimeException while transforming  " + className);
                t.printStackTrace();
                throw t;
            }
        }
        return null;
    }

    private byte[] transformBytes(ClassLoader loader, String className, byte[] classfileBuffer) {
        ClassReader reader = new ClassReader(classfileBuffer);
        ComputeClassWriter writer = new ComputeClassWriter(new ClassloaderByteArraySource(loader), this.computeCache, FrameOptions.pickFlags(classfileBuffer));
        int id = CodeCoverageStore.registerClass(className);
        reader.accept(new CoverageClassVisitor(id, writer), 8);
        return writer.toByteArray();
    }

    private boolean shouldInclude(String className) {
        return (Boolean)this.filter.apply(className);
    }

    private ClassLoader pickLoader(ClassLoader loader) {
        if (loader != null) {
            return loader;
        }
        return ClassLoader.getSystemClassLoader();
    }
}

