/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.coverage.execute;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.pitest.bytecode.FrameOptions;
import org.pitest.classinfo.ComputeClassWriter;
import org.pitest.classpath.ClassloaderByteArraySource;
import org.pitest.coverage.CoverageClassVisitor;
import org.pitest.reflection.Reflection;
import org.pitest.reloc.asm.ClassReader;
import org.pitest.util.IsolationUtils;
import org.pitest.util.StreamUtil;
import org.pitest.util.Unchecked;
import sun.pitest.CodeCoverageStore;

public final class JavassistCoverageInterceptor {
    private static final Map<String, String> COMPUTE_CACHE = new ConcurrentHashMap<String, String>();

    private JavassistCoverageInterceptor() {
    }

    public static InputStream openClassfile(Object classPath, String name) {
        try {
            if (JavassistCoverageInterceptor.isInstrumentedClass(name)) {
                byte[] bs = JavassistCoverageInterceptor.getOriginalBytes(classPath, name);
                return new ByteArrayInputStream(JavassistCoverageInterceptor.transformBytes(IsolationUtils.getContextClassLoader(), name, bs));
            }
            return JavassistCoverageInterceptor.returnNormalBytes(classPath, name);
        }
        catch (IOException ex) {
            throw Unchecked.translateCheckedException(ex);
        }
    }

    private static byte[] getOriginalBytes(Object classPath, String name) throws IOException {
        try (InputStream is = JavassistCoverageInterceptor.returnNormalBytes(classPath, name);){
            byte[] bs;
            byte[] byArray = bs = StreamUtil.streamToByteArray(is);
            return byArray;
        }
    }

    private static byte[] transformBytes(ClassLoader loader, String className, byte[] classfileBuffer) {
        ClassReader reader = new ClassReader(classfileBuffer);
        ComputeClassWriter writer = new ComputeClassWriter(new ClassloaderByteArraySource(loader), COMPUTE_CACHE, FrameOptions.pickFlags(classfileBuffer));
        int id = CodeCoverageStore.registerClass(className);
        reader.accept(new CoverageClassVisitor(id, writer), 8);
        return writer.toByteArray();
    }

    private static InputStream returnNormalBytes(Object classPath, String name) {
        try {
            return (InputStream)Reflection.publicMethod(classPath.getClass(), "openClassfile").invoke(classPath, name);
        }
        catch (Exception e) {
            throw Unchecked.translateCheckedException(e);
        }
    }

    private static boolean isInstrumentedClass(String name) {
        return true;
    }
}

