/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.dependency;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.pitest.bytecode.NullVisitor;
import org.pitest.classinfo.ClassByteArraySource;
import org.pitest.dependency.DependencyAccess;
import org.pitest.dependency.DependencyClassVisitor;
import org.pitest.dependency.IgnoreCoreClasses;
import org.pitest.functional.F;
import org.pitest.functional.F2;
import org.pitest.functional.FCollection;
import org.pitest.functional.Option;
import org.pitest.functional.SideEffect1;
import org.pitest.functional.predicate.Predicate;
import org.pitest.functional.prelude.Prelude;
import org.pitest.reloc.asm.ClassReader;
import org.pitest.util.Functions;
import org.pitest.util.Log;

public class DependencyExtractor {
    private static final Logger LOG = Log.getLogger();
    private final int depth;
    private final ClassByteArraySource classToBytes;

    public DependencyExtractor(ClassByteArraySource classToBytes, int depth) {
        this.depth = depth;
        this.classToBytes = classToBytes;
    }

    public Collection<String> extractCallDependenciesForPackages(String clazz, Predicate<String> targetPackages) throws IOException {
        Set<String> allDependencies = this.extractCallDependencies(clazz, new IgnoreCoreClasses());
        return FCollection.filter(allDependencies, Prelude.and(DependencyExtractor.asJVMNamePredicate(targetPackages), DependencyExtractor.notSuppliedClass(clazz)));
    }

    private static F<String, Boolean> notSuppliedClass(final String clazz) {
        return new F<String, Boolean>(){

            @Override
            public Boolean apply(String a) {
                return !Functions.jvmClassToClassName().apply(a).equals(clazz);
            }
        };
    }

    private static F<String, Boolean> asJVMNamePredicate(final Predicate<String> predicate) {
        return new F<String, Boolean>(){

            @Override
            public Boolean apply(String a) {
                return (Boolean)predicate.apply(Functions.jvmClassToClassName().apply(a));
            }
        };
    }

    public Collection<String> extractCallDependenciesForPackages(String clazz, Predicate<String> targetPackages, Predicate<DependencyAccess> doNotTraverse) throws IOException {
        Set<String> allDependencies = this.extractCallDependencies(clazz, doNotTraverse);
        return FCollection.filter(allDependencies, targetPackages);
    }

    Set<String> extractCallDependencies(String clazz, Predicate<DependencyAccess> filter) throws IOException {
        return this.extractCallDependencies(clazz, new TreeSet<String>(), filter, 0);
    }

    public int getMaxDistance() {
        return this.depth;
    }

    private Set<String> extractCallDependencies(String clazz, TreeSet<String> visited, Predicate<DependencyAccess> filter, int currentDepth) throws IOException {
        Map<String, List<DependencyAccess>> classesToAccesses = this.groupDependenciesByClass(this.extractRelevantDependencies(clazz, filter));
        HashSet<String> dependencies = new HashSet<String>(classesToAccesses.keySet());
        dependencies.removeAll(visited);
        visited.addAll(dependencies);
        if (currentDepth < this.depth - 1 || this.depth == 0) {
            dependencies.addAll(this.examineChildDependencies(currentDepth, dependencies, visited, filter));
        }
        return dependencies;
    }

    private Set<String> examineChildDependencies(int currentDepth, Set<String> classes, TreeSet<String> visited, Predicate<DependencyAccess> filter) throws IOException {
        HashSet<String> deps = new HashSet<String>();
        for (String each : classes) {
            Set<String> childDependencies = this.extractCallDependencies(each, visited, filter, currentDepth + 1);
            deps.addAll(childDependencies);
        }
        return deps;
    }

    private Set<DependencyAccess> extractRelevantDependencies(String clazz, Predicate<DependencyAccess> filter) throws IOException {
        List<DependencyAccess> dependencies = this.extract(clazz, filter);
        TreeSet<DependencyAccess> relevantDependencies = new TreeSet<DependencyAccess>(DependencyExtractor.equalDestinationComparator());
        FCollection.filter(dependencies, filter, relevantDependencies);
        return relevantDependencies;
    }

    private static Comparator<DependencyAccess> equalDestinationComparator() {
        return new Comparator<DependencyAccess>(){

            @Override
            public int compare(DependencyAccess o1, DependencyAccess o2) {
                return o1.getDest().compareTo(o2.getDest());
            }
        };
    }

    private List<DependencyAccess> extract(String clazz, Predicate<DependencyAccess> filter) throws IOException {
        Option<byte[]> bytes = this.classToBytes.getBytes(clazz);
        if (bytes.hasNone()) {
            LOG.warning("No bytes found for " + clazz);
            return Collections.emptyList();
        }
        ClassReader reader = new ClassReader(bytes.value());
        ArrayList<DependencyAccess> dependencies = new ArrayList<DependencyAccess>();
        SideEffect1<DependencyAccess> se = DependencyExtractor.constructCollectingSideEffectForVisitor(dependencies, Prelude.and(Prelude.not(DependencyExtractor.nameIsEqual(clazz)), filter));
        DependencyClassVisitor dcv = new DependencyClassVisitor(new NullVisitor(), se);
        reader.accept(dcv, 8);
        return dependencies;
    }

    private Map<String, List<DependencyAccess>> groupDependenciesByClass(Set<DependencyAccess> relevantDependencies) {
        ArrayList sortedByClass = new ArrayList(relevantDependencies.size());
        Collections.sort(sortedByClass, DependencyExtractor.classNameComparator());
        return FCollection.fold(DependencyExtractor.addDependenciesToMap(), new HashMap(), relevantDependencies);
    }

    private static F2<Map<String, List<DependencyAccess>>, DependencyAccess, Map<String, List<DependencyAccess>>> addDependenciesToMap() {
        return new F2<Map<String, List<DependencyAccess>>, DependencyAccess, Map<String, List<DependencyAccess>>>(){

            @Override
            public Map<String, List<DependencyAccess>> apply(Map<String, List<DependencyAccess>> map, DependencyAccess access) {
                List<DependencyAccess> list = map.get(access.getDest().getOwner());
                if (list == null) {
                    list = new ArrayList<DependencyAccess>();
                }
                list.add(access);
                map.put(access.getDest().getOwner(), list);
                return map;
            }
        };
    }

    private static Comparator<DependencyAccess> classNameComparator() {
        return new Comparator<DependencyAccess>(){

            @Override
            public int compare(DependencyAccess lhs, DependencyAccess rhs) {
                return lhs.getDest().getOwner().compareTo(rhs.getDest().getOwner());
            }
        };
    }

    private static Predicate<DependencyAccess> nameIsEqual(final String clazz) {
        return new Predicate<DependencyAccess>(){

            @Override
            public Boolean apply(DependencyAccess a) {
                return a.getDest().getOwner().equals(clazz);
            }
        };
    }

    private static SideEffect1<DependencyAccess> constructCollectingSideEffectForVisitor(final List<DependencyAccess> dependencies, final Predicate<DependencyAccess> predicate) {
        SideEffect1<DependencyAccess> se = new SideEffect1<DependencyAccess>(){

            @Override
            public void apply(DependencyAccess a) {
                if (((Boolean)predicate.apply(a)).booleanValue()) {
                    dependencies.add(a);
                }
            }
        };
        return se;
    }
}

