/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.functional;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.pitest.functional.F;
import org.pitest.functional.FunctionalList;
import org.pitest.functional.MutableList;

public abstract class FArray {
    public static <T> void filter(T[] xs, F<T, Boolean> predicate, Collection<T> dest) {
        if (xs != null) {
            for (T x : xs) {
                if (!predicate.apply(x).booleanValue()) continue;
                dest.add(x);
            }
        }
    }

    public static <T> List<T> filter(T[] xs, F<T, Boolean> predicate) {
        ArrayList dest = new ArrayList();
        FArray.filter(xs, predicate, dest);
        return dest;
    }

    public static <T> boolean contains(T[] xs, F<T, Boolean> predicate) {
        for (T x : xs) {
            if (!predicate.apply(x).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static <A, B> void flatMapTo(A[] as, F<A, ? extends Iterable<B>> f, Collection<? super B> bs) {
        if (as != null) {
            for (A a : as) {
                for (B each : f.apply(a)) {
                    bs.add(each);
                }
            }
        }
    }

    public static <A, B> FunctionalList<B> flatMap(A[] as, F<A, ? extends Iterable<B>> f) {
        FunctionalList bs = FArray.emptyList();
        FArray.flatMapTo(as, f, bs);
        return bs;
    }

    private static <T> FunctionalList<T> emptyList() {
        return new MutableList();
    }
}

