/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.functional;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.FunctionalList;
import org.pitest.functional.Option;
import org.pitest.functional.SideEffect1;

public final class MutableList<A>
implements FunctionalList<A> {
    private static final long serialVersionUID = 1L;
    private final List<A> impl;

    @SafeVarargs
    public MutableList(A ... as) {
        this(Arrays.asList(as));
    }

    public MutableList(List<A> impl) {
        this.impl = impl;
    }

    public MutableList() {
        this(new ArrayList());
    }

    @Override
    public boolean add(A o) {
        return this.impl.add(o);
    }

    @Override
    public boolean addAll(Collection<? extends A> c) {
        return this.impl.addAll(c);
    }

    @Override
    public void clear() {
        this.impl.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.impl.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.impl.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.impl.isEmpty();
    }

    @Override
    public Iterator<A> iterator() {
        return this.impl.iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.impl.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.impl.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.impl.retainAll(c);
    }

    @Override
    public int size() {
        return this.impl.size();
    }

    @Override
    public Object[] toArray() {
        return this.impl.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.impl.toArray(a);
    }

    @Override
    public boolean contains(F<A, Boolean> predicate) {
        return FCollection.contains(this, predicate);
    }

    @Override
    public FunctionalList<A> filter(F<A, Boolean> predicate) {
        return FCollection.filter(this, predicate);
    }

    @Override
    public <B> FunctionalList<B> flatMap(F<A, ? extends Iterable<B>> f) {
        return FCollection.flatMap(this, f);
    }

    @Override
    public void forEach(SideEffect1<A> e) {
        FCollection.forEach(this, e);
    }

    @Override
    public <B> FunctionalList<B> map(F<A, B> f) {
        return FCollection.map(this, f);
    }

    @Override
    public <B> void mapTo(F<A, B> f, Collection<? super B> bs) {
        FCollection.mapTo(this, f, bs);
    }

    @Override
    public Option<A> findFirst(F<A, Boolean> predicate) {
        return FCollection.findFirst(this.impl, predicate);
    }

    @Override
    public void add(int arg0, A arg1) {
        this.impl.add(arg0, arg1);
    }

    @Override
    public boolean addAll(int arg0, Collection<? extends A> arg1) {
        return this.impl.addAll(arg0, arg1);
    }

    @Override
    public A get(int index) {
        return this.impl.get(index);
    }

    @Override
    public int indexOf(Object arg0) {
        return this.impl.indexOf(arg0);
    }

    @Override
    public int lastIndexOf(Object arg0) {
        return this.impl.lastIndexOf(arg0);
    }

    @Override
    public ListIterator<A> listIterator() {
        return this.impl.listIterator();
    }

    @Override
    public ListIterator<A> listIterator(int index) {
        return this.impl.listIterator(index);
    }

    @Override
    public A remove(int index) {
        return this.impl.remove(index);
    }

    @Override
    public A set(int index, A element) {
        return this.impl.set(index, element);
    }

    @Override
    public List<A> subList(int fromIndex, int toIndex) {
        return this.impl.subList(fromIndex, toIndex);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.impl == null ? 0 : this.impl.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MutableList other = (MutableList)obj;
        return !(this.impl == null ? other.impl != null : !this.impl.equals(other.impl));
    }

    public String toString() {
        return this.impl.toString();
    }
}

