/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.junit;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import org.pitest.testapi.TestSuiteFinder;

public class JUnit4SuiteFinder
implements TestSuiteFinder {
    @Override
    public List<Class<?>> apply(Class<?> a) {
        Suite.SuiteClasses annotation = a.getAnnotation(Suite.SuiteClasses.class);
        if (annotation != null && this.hasSuitableRunnner(a)) {
            return Arrays.asList(annotation.value());
        }
        return Collections.emptyList();
    }

    private boolean hasSuitableRunnner(Class<?> clazz) {
        RunWith runWith = clazz.getAnnotation(RunWith.class);
        if (runWith != null) {
            return runWith.value().equals(Suite.class);
        }
        return false;
    }
}

