/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.junit;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;
import org.junit.internal.runners.ErrorReportingRunner;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runners.Parameterized;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.Option;
import org.pitest.junit.DescriptionFilter;
import org.pitest.junit.adapter.AdaptedJUnitTestUnit;
import org.pitest.reflection.IsAnnotatedWith;
import org.pitest.reflection.Reflection;
import org.pitest.testapi.TestGroupConfig;
import org.pitest.testapi.TestUnit;
import org.pitest.testapi.TestUnitFinder;
import org.pitest.util.IsolationUtils;
import org.pitest.util.Preconditions;

public class JUnitCustomRunnerTestUnitFinder
implements TestUnitFinder {
    private static final Option<Class> CLASS_RULE = JUnitCustomRunnerTestUnitFinder.findClassRuleClass();
    private final TestGroupConfig config;
    private final Collection<String> excludedRunners;
    private final Collection<String> includedTestMethods;

    JUnitCustomRunnerTestUnitFinder(TestGroupConfig config, Collection<String> excludedRunners, Collection<String> includedTestMethods) {
        Preconditions.checkNotNull(config);
        this.config = config;
        this.excludedRunners = excludedRunners;
        this.includedTestMethods = includedTestMethods;
    }

    @Override
    public List<TestUnit> findTestUnits(Class<?> clazz) {
        Runner runner = AdaptedJUnitTestUnit.createRunner(clazz);
        if (this.isExcluded(runner) || this.isNotARunnableTest(runner, clazz.getName()) || !this.isIncluded(clazz)) {
            return Collections.emptyList();
        }
        if (Filterable.class.isAssignableFrom(runner.getClass()) && !this.shouldTreatAsOneUnit(clazz, runner)) {
            List<TestUnit> filteredUnits = this.splitIntoFilteredUnits(runner.getDescription());
            return this.filterUnitsByMethod(filteredUnits);
        }
        return Collections.singletonList(new AdaptedJUnitTestUnit(clazz, Option.none()));
    }

    private List<TestUnit> filterUnitsByMethod(List<TestUnit> filteredUnits) {
        if (this.includedTestMethods.isEmpty()) {
            return filteredUnits;
        }
        ArrayList<TestUnit> units = new ArrayList<TestUnit>();
        for (TestUnit unit : filteredUnits) {
            if (!this.includedTestMethods.contains(unit.getDescription().getName().split("\\(")[0])) continue;
            units.add(unit);
        }
        return units;
    }

    private boolean isExcluded(Runner runner) {
        return this.excludedRunners.contains(runner.getClass().getName());
    }

    private boolean isIncluded(Class<?> a) {
        return this.isIncludedCategory(a) && !this.isExcludedCategory(a);
    }

    private boolean isIncludedCategory(Class<?> a) {
        List<String> included = this.config.getIncludedGroups();
        return included.isEmpty() || !Collections.disjoint(included, this.getCategories(a));
    }

    private boolean isExcludedCategory(Class<?> a) {
        List<String> excluded = this.config.getExcludedGroups();
        return !excluded.isEmpty() && !Collections.disjoint(excluded, this.getCategories(a));
    }

    private List<String> getCategories(Class<?> a) {
        Category c = a.getAnnotation(Category.class);
        return FCollection.flatMap(Arrays.asList(c), this.toCategoryNames());
    }

    private F<Category, Iterable<String>> toCategoryNames() {
        return new F<Category, Iterable<String>>(){

            @Override
            public Iterable<String> apply(Category a) {
                if (a == null) {
                    return Collections.emptyList();
                }
                return FCollection.map(Arrays.asList(a.value()), JUnitCustomRunnerTestUnitFinder.this.toName());
            }
        };
    }

    private F<Class<?>, String> toName() {
        return new F<Class<?>, String>(){

            @Override
            public String apply(Class<?> a) {
                return a.getName();
            }
        };
    }

    private boolean isNotARunnableTest(Runner runner, String className) {
        try {
            return runner == null || runner.getClass().isAssignableFrom(ErrorReportingRunner.class) || this.isParameterizedTest(runner) || this.isAJUnitThreeErrorOrWarning(runner) || this.isJUnitThreeSuiteMethodNotForOwnClass(runner, className);
        }
        catch (RuntimeException ex) {
            return true;
        }
    }

    private boolean isAJUnitThreeErrorOrWarning(Runner runner) {
        return !runner.getDescription().getChildren().isEmpty() && ((Description)runner.getDescription().getChildren().get(0)).getClassName().startsWith("junit.framework.TestSuite");
    }

    private boolean shouldTreatAsOneUnit(Class<?> clazz, Runner runner) {
        Set<Method> methods = Reflection.allMethods(clazz);
        return this.runnerCannotBeSplit(runner) || this.hasAnnotation(methods, BeforeClass.class) || this.hasAnnotation(methods, AfterClass.class) || this.hasClassRuleAnnotations(clazz, methods);
    }

    private boolean hasClassRuleAnnotations(Class<?> clazz, Set<Method> methods) {
        if (CLASS_RULE.hasNone()) {
            return false;
        }
        return this.hasAnnotation(methods, CLASS_RULE.value()) || this.hasAnnotation(Reflection.publicFields(clazz), CLASS_RULE.value());
    }

    private boolean hasAnnotation(Set<? extends AccessibleObject> methods, Class<? extends Annotation> annotation) {
        return FCollection.contains(methods, IsAnnotatedWith.instance(annotation));
    }

    private boolean isParameterizedTest(Runner runner) {
        return Parameterized.class.isAssignableFrom(runner.getClass());
    }

    private boolean runnerCannotBeSplit(Runner runner) {
        String runnerName = runner.getClass().getName();
        return runnerName.equals("junitparams.JUnitParamsRunner") || runnerName.startsWith("org.spockframework.runtime.Sputnik") || runnerName.startsWith("com.insightfullogic.lambdabehave") || runnerName.startsWith("com.googlecode.yatspec") || runnerName.startsWith("com.google.gwtmockito.GwtMockitoTestRunner");
    }

    private boolean isJUnitThreeSuiteMethodNotForOwnClass(Runner runner, String className) {
        return runner.getClass().getName().equals("org.junit.internal.runners.SuiteMethod") && !runner.getDescription().getClassName().equals(className);
    }

    private List<TestUnit> splitIntoFilteredUnits(Description description) {
        return FCollection.filter(description.getChildren(), this.isTest()).map(this.descriptionToTestUnit());
    }

    private F<Description, TestUnit> descriptionToTestUnit() {
        return new F<Description, TestUnit>(){

            @Override
            public TestUnit apply(Description a) {
                return JUnitCustomRunnerTestUnitFinder.this.descriptionToTest(a);
            }
        };
    }

    private F<Description, Boolean> isTest() {
        return new F<Description, Boolean>(){

            @Override
            public Boolean apply(Description a) {
                return a.isTest();
            }
        };
    }

    private TestUnit descriptionToTest(Description description) {
        Class<?> clazz = description.getTestClass();
        if (clazz == null) {
            clazz = IsolationUtils.convertForClassLoader(IsolationUtils.getContextClassLoader(), description.getClassName());
        }
        return new AdaptedJUnitTestUnit(clazz, Option.some(this.createFilterFor(description)));
    }

    private Filter createFilterFor(Description description) {
        return new DescriptionFilter(description.toString());
    }

    private static Option<Class> findClassRuleClass() {
        try {
            return Option.some(Class.forName("org.junit.ClassRule"));
        }
        catch (ClassNotFoundException ex) {
            return Option.none();
        }
    }
}

