/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.junit;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class JUnitVersion
implements Comparable<JUnitVersion> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+).*");
    private final int major;
    private final int minor;

    public static JUnitVersion parse(String version) {
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid version string! Could not parse " + version);
        }
        int major = Integer.parseInt(matcher.group(1));
        int minor = Integer.parseInt(matcher.group(2));
        return new JUnitVersion(major, minor);
    }

    private JUnitVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    @Override
    public int compareTo(JUnitVersion that) {
        if (that == null) {
            return 1;
        }
        if (this.major != that.major) {
            return this.major - that.major;
        }
        if (this.minor != that.minor) {
            return this.minor - that.minor;
        }
        return 0;
    }

    public boolean is(JUnitVersion version) {
        return this.equals(version);
    }

    public boolean isGreaterThan(JUnitVersion version) {
        return this.compareTo(version) > 0;
    }

    public boolean isGreaterThanOrEqualTo(JUnitVersion version) {
        return this.compareTo(version) >= 0;
    }

    public boolean isLessThan(JUnitVersion version) {
        return this.compareTo(version) < 0;
    }

    public boolean isLessThanOrEqualTo(JUnitVersion version) {
        return this.compareTo(version) <= 0;
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JUnitVersion)) {
            return false;
        }
        JUnitVersion that = (JUnitVersion)o;
        return this.major == that.major && this.minor == that.minor;
    }

    public String toString() {
        return this.major + "." + this.minor;
    }
}

