/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.junit.adapter;

import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.StoppedByUserException;
import org.pitest.testapi.ResultCollector;

class AdaptingRunListener
extends RunListener {
    private final org.pitest.testapi.Description description;
    private final ResultCollector rc;
    private boolean failed = false;

    AdaptingRunListener(org.pitest.testapi.Description description, ResultCollector rc) {
        this.description = description;
        this.rc = rc;
    }

    public void testFailure(Failure failure) throws Exception {
        this.rc.notifyEnd(this.description, failure.getException());
        this.failed = true;
    }

    public void testAssumptionFailure(Failure failure) {
    }

    public void testIgnored(Description description) throws Exception {
        this.rc.notifySkipped(this.description);
    }

    public void testStarted(Description description) throws Exception {
        if (this.failed) {
            throw new StoppedByUserException();
        }
        this.rc.notifyStart(this.description);
    }

    public void testFinished(Description description) throws Exception {
        if (!this.failed) {
            this.rc.notifyEnd(this.description);
        }
    }
}

