/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.engine.gregor;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.pitest.classinfo.ClassName;
import org.pitest.functional.F;
import org.pitest.mutationtest.engine.Location;
import org.pitest.mutationtest.engine.MethodName;
import org.pitest.mutationtest.engine.gregor.AvoidAssertsMethodAdapter;
import org.pitest.mutationtest.engine.gregor.AvoidStringSwitchedMethodAdapter;
import org.pitest.mutationtest.engine.gregor.ClassContext;
import org.pitest.mutationtest.engine.gregor.ClassInfo;
import org.pitest.mutationtest.engine.gregor.LineTrackingMethodVisitor;
import org.pitest.mutationtest.engine.gregor.MethodInfo;
import org.pitest.mutationtest.engine.gregor.MethodMutationContext;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.mutationtest.engine.gregor.analysis.InstructionTrackingMethodVisitor;
import org.pitest.mutationtest.engine.gregor.blocks.BlockTrackingMethodDecorator;
import org.pitest.reloc.asm.ClassVisitor;
import org.pitest.reloc.asm.MethodVisitor;

class MutatingClassVisitor
extends ClassVisitor {
    private final F<MethodInfo, Boolean> filter;
    private final ClassContext context;
    private final Set<MethodMutatorFactory> methodMutators = new HashSet<MethodMutatorFactory>();

    MutatingClassVisitor(ClassVisitor delegateClassVisitor, ClassContext context, F<MethodInfo, Boolean> filter, Collection<MethodMutatorFactory> mutators) {
        super(393216, delegateClassVisitor);
        this.context = context;
        this.filter = filter;
        this.methodMutators.addAll(mutators);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.context.registerClass(new ClassInfo(version, access, name, signature, superName, interfaces));
    }

    @Override
    public void visitSource(String source, String debug) {
        super.visitSource(source, debug);
        this.context.registerSourceFile(source);
    }

    @Override
    public MethodVisitor visitMethod(int access, String methodName, String methodDescriptor, String signature, String[] exceptions) {
        MethodMutationContext methodContext = new MethodMutationContext(this.context, Location.location(ClassName.fromString(this.context.getClassInfo().getName()), MethodName.fromString(methodName), methodDescriptor));
        MethodVisitor methodVisitor = this.cv.visitMethod(access, methodName, methodDescriptor, signature, exceptions);
        MethodInfo info = new MethodInfo().withOwner(this.context.getClassInfo()).withAccess(access).withMethodName(methodName).withMethodDescriptor(methodDescriptor);
        if (this.filter.apply(info).booleanValue()) {
            return this.visitMethodForMutation(methodContext, info, methodVisitor);
        }
        return methodVisitor;
    }

    private MethodVisitor visitMethodForMutation(MethodMutationContext methodContext, MethodInfo methodInfo, MethodVisitor methodVisitor) {
        MethodVisitor next = methodVisitor;
        for (MethodMutatorFactory each : this.methodMutators) {
            next = each.create(methodContext, methodInfo, next);
        }
        return new InstructionTrackingMethodVisitor(MutatingClassVisitor.wrapWithDecorators(methodContext, this.wrapWithFilters(methodContext, next)), methodContext);
    }

    private static MethodVisitor wrapWithDecorators(MethodMutationContext methodContext, MethodVisitor mv) {
        return MutatingClassVisitor.wrapWithBlockTracker(methodContext, MutatingClassVisitor.wrapWithLineTracker(methodContext, mv));
    }

    private static MethodVisitor wrapWithBlockTracker(MethodMutationContext methodContext, MethodVisitor mv) {
        return new BlockTrackingMethodDecorator(methodContext, mv);
    }

    private static MethodVisitor wrapWithLineTracker(MethodMutationContext methodContext, MethodVisitor mv) {
        return new LineTrackingMethodVisitor(methodContext, mv);
    }

    private MethodVisitor wrapWithFilters(MethodMutationContext methodContext, MethodVisitor wrappedMethodVisitor) {
        return MutatingClassVisitor.wrapWithStringSwitchFilter(methodContext, MutatingClassVisitor.wrapWithAssertFilter(methodContext, wrappedMethodVisitor));
    }

    private static MethodVisitor wrapWithStringSwitchFilter(MethodMutationContext methodContext, MethodVisitor wrappedMethodVisitor) {
        return new AvoidStringSwitchedMethodAdapter(methodContext, wrappedMethodVisitor);
    }

    private static MethodVisitor wrapWithAssertFilter(MethodMutationContext methodContext, MethodVisitor wrappedMethodVisitor) {
        return new AvoidAssertsMethodAdapter(methodContext, wrappedMethodVisitor);
    }
}

