/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.execute;

import org.pitest.functional.Option;
import org.pitest.mutationtest.DetectionStatus;
import org.pitest.testapi.Description;
import org.pitest.testapi.TestListener;
import org.pitest.testapi.TestResult;

public class CheckTestHasFailedResultListener
implements TestListener {
    private Option<Description> lastFailingTest = Option.none();
    private int testsRun = 0;

    @Override
    public void onTestFailure(TestResult tr) {
        this.lastFailingTest = Option.some(tr.getDescription());
    }

    @Override
    public void onTestSkipped(TestResult tr) {
    }

    @Override
    public void onTestStart(Description d) {
        ++this.testsRun;
    }

    @Override
    public void onTestSuccess(TestResult tr) {
    }

    public DetectionStatus status() {
        if (this.lastFailingTest.hasSome()) {
            return DetectionStatus.KILLED;
        }
        return DetectionStatus.SURVIVED;
    }

    public Option<Description> lastFailingTest() {
        return this.lastFailingTest;
    }

    public int getNumberOfTestsRun() {
        return this.testsRun;
    }

    @Override
    public void onRunEnd() {
    }

    @Override
    public void onRunStart() {
    }
}

