/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.execute;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pitest.coverage.TestInfo;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.Option;
import org.pitest.mutationtest.TimeoutLengthStrategy;
import org.pitest.mutationtest.execute.MutationTimeoutDecorator;
import org.pitest.mutationtest.execute.Reporter;
import org.pitest.mutationtest.execute.TimeOutSystemExitSideEffect;
import org.pitest.testapi.TestUnit;

public class TimeOutDecoratedTestSource {
    private final Map<String, TestUnit> allTests = new HashMap<String, TestUnit>();
    private final TimeoutLengthStrategy timeoutStrategy;
    private final Reporter r;

    public TimeOutDecoratedTestSource(TimeoutLengthStrategy timeoutStrategy, List<TestUnit> allTests, Reporter r) {
        this.timeoutStrategy = timeoutStrategy;
        this.mapTests(allTests);
        this.r = r;
    }

    private void mapTests(List<TestUnit> tests) {
        for (TestUnit each : tests) {
            this.allTests.put(each.getDescription().getQualifiedName(), each);
        }
    }

    public List<TestUnit> translateTests(List<TestInfo> testsInOrder) {
        return FCollection.flatMap(testsInOrder, this.testToTestUnit());
    }

    private F<TestInfo, Option<TestUnit>> testToTestUnit() {
        return new F<TestInfo, Option<TestUnit>>(){

            @Override
            public Option<TestUnit> apply(TestInfo a) {
                TestUnit tu = (TestUnit)TimeOutDecoratedTestSource.this.allTests.get(a.getName());
                if (tu != null) {
                    return Option.some(new MutationTimeoutDecorator(tu, new TimeOutSystemExitSideEffect(TimeOutDecoratedTestSource.this.r), TimeOutDecoratedTestSource.this.timeoutStrategy, a.getTime()));
                }
                return Option.none();
            }
        };
    }
}

