/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.sequence;

import org.pitest.sequence.Context;

public abstract class Match<T> {
    public abstract boolean test(Context<T> var1, T var2);

    public static <T> Match<T> always() {
        return new Match<T>(){

            @Override
            public boolean test(Context<T> c, T t) {
                return true;
            }
        };
    }

    public static <T> Match<T> never() {
        return new Match<T>(){

            @Override
            public boolean test(Context<T> c, T t) {
                return false;
            }
        };
    }

    public static <T> Match<T> isEqual(final Object targetRef) {
        return new Match<T>(){

            @Override
            public boolean test(Context<T> c, T t) {
                return targetRef.equals(t);
            }
        };
    }

    public Match<T> and(final Match<T> other) {
        final Match self = this;
        return new Match<T>(){

            @Override
            public boolean test(Context<T> c, T t) {
                return self.test(c, t) && other.test(c, t);
            }
        };
    }

    public Match<T> negate() {
        final Match self = this;
        return new Match<T>(){

            @Override
            public boolean test(Context<T> c, T t) {
                return !self.test(c, t);
            }
        };
    }

    public Match<T> or(final Match<T> other) {
        final Match self = this;
        return new Match<T>(){

            @Override
            public boolean test(Context<T> c, T t) {
                return self.test(c, t) || other.test(c, t);
            }
        };
    }
}

