/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.sequence;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.pitest.sequence.Consume;
import org.pitest.sequence.Context;
import org.pitest.sequence.EndMatch;
import org.pitest.sequence.Match;
import org.pitest.sequence.SequenceMatcher;
import org.pitest.sequence.Split;
import org.pitest.sequence.State;

class NFASequenceMatcher<T>
implements SequenceMatcher<T> {
    private final boolean debug;
    private final Match<T> ignore;
    private final State<T> start;

    NFASequenceMatcher(Match<T> ignore, State<T> state, boolean debug) {
        this.ignore = ignore;
        this.start = state;
        this.debug = debug;
    }

    @Override
    public boolean matches(List<T> sequence) {
        return this.matches(sequence, Context.start(sequence, this.debug));
    }

    @Override
    public boolean matches(List<T> sequence, Context<T> context) {
        Set<State<T>> currentState = new HashSet<State<T>>();
        NFASequenceMatcher.addstate(currentState, this.start);
        for (T t : sequence) {
            context.moveForward();
            if (this.ignore.test(context, t)) continue;
            Set<State<T>> nextStates = NFASequenceMatcher.step(context, currentState, t);
            currentState = nextStates;
        }
        return NFASequenceMatcher.isMatch(currentState);
    }

    private static <T> void addstate(Set<State<T>> set, State<T> state) {
        if (state == null) {
            return;
        }
        if (state instanceof Split) {
            Split split = (Split)state;
            NFASequenceMatcher.addstate(set, split.out1);
            NFASequenceMatcher.addstate(set, split.out2);
        } else {
            set.add(state);
        }
    }

    private static <T> Set<State<T>> step(Context<T> context, Set<State<T>> currentState, T c) {
        HashSet<State<T>> nextStates = new HashSet<State<T>>();
        for (State<T> each : currentState) {
            if (!(each instanceof Consume)) continue;
            Consume consume = (Consume)each;
            if (!consume.c.test(context, c)) continue;
            NFASequenceMatcher.addstate(nextStates, consume.out);
        }
        return nextStates;
    }

    private static <T> boolean isMatch(Set<State<T>> currentState) {
        return currentState.contains(EndMatch.MATCH);
    }
}

