/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.testapi.execute;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.pitest.testapi.Configuration;
import org.pitest.testapi.TestUnit;

public class FindTestUnits {
    private final Configuration config;

    public FindTestUnits(Configuration config) {
        this.config = config;
    }

    public List<TestUnit> findTestUnitsForAllSuppliedClasses(Iterable<Class<?>> classes) {
        ArrayList<TestUnit> testUnits = new ArrayList<TestUnit>();
        for (Class<?> c : classes) {
            Collection<TestUnit> testUnitsFromClass = this.getTestUnits(c);
            testUnits.addAll(testUnitsFromClass);
        }
        return testUnits;
    }

    private Collection<TestUnit> getTestUnits(Class<?> suiteClass) {
        ArrayList<TestUnit> tus = new ArrayList<TestUnit>();
        HashSet visitedClasses = new HashSet();
        this.findTestUnits(tus, visitedClasses, suiteClass);
        return tus;
    }

    private void findTestUnits(List<TestUnit> tus, Set<Class<?>> visitedClasses, Class<?> suiteClass) {
        visitedClasses.add(suiteClass);
        Collection tcs = (Collection)this.config.testSuiteFinder().apply(suiteClass);
        for (Class tc : tcs) {
            if (visitedClasses.contains(tc)) continue;
            this.findTestUnits(tus, visitedClasses, tc);
        }
        List<TestUnit> testsInThisClass = this.config.testUnitFinder().findTestUnits(suiteClass);
        if (!testsInThisClass.isEmpty()) {
            tus.addAll(testsInThisClass);
        }
    }
}

