/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.testapi.execute;

import org.pitest.functional.F;
import org.pitest.functional.SideEffect1;
import org.pitest.testapi.TestListener;
import org.pitest.testapi.TestResult;

public enum ResultType {
    PASS(new ResultToListenerSideEffect(){

        @Override
        public SideEffect1<TestListener> apply(TestResult a) {
            return ResultType.success(a);
        }
    }),
    FAIL(new ResultToListenerSideEffect(){

        @Override
        public SideEffect1<TestListener> apply(TestResult a) {
            return ResultType.failure(a);
        }
    }),
    SKIPPED(new ResultToListenerSideEffect(){

        @Override
        public SideEffect1<TestListener> apply(TestResult a) {
            return ResultType.skipped(a);
        }
    }),
    STARTED(new ResultToListenerSideEffect(){

        @Override
        public SideEffect1<TestListener> apply(TestResult a) {
            return ResultType.started(a);
        }
    });

    private final F<TestResult, SideEffect1<TestListener>> function;

    private ResultType(ResultToListenerSideEffect f) {
        this.function = f;
    }

    public SideEffect1<TestListener> getListenerFunction(TestResult result) {
        return this.function.apply(result);
    }

    public static SideEffect1<TestListener> success(final TestResult result) {
        return new SideEffect1<TestListener>(){

            @Override
            public void apply(TestListener a) {
                a.onTestSuccess(result);
            }
        };
    }

    public static SideEffect1<TestListener> failure(final TestResult result) {
        return new SideEffect1<TestListener>(){

            @Override
            public void apply(TestListener a) {
                a.onTestFailure(result);
            }
        };
    }

    public static SideEffect1<TestListener> skipped(final TestResult result) {
        return new SideEffect1<TestListener>(){

            @Override
            public void apply(TestListener a) {
                a.onTestSkipped(result);
            }
        };
    }

    public static SideEffect1<TestListener> started(final TestResult result) {
        return new SideEffect1<TestListener>(){

            @Override
            public void apply(TestListener a) {
                a.onTestStart(result.getDescription());
            }
        };
    }

    private static interface ResultToListenerSideEffect
    extends F<TestResult, SideEffect1<TestListener>> {
    }
}

