/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.util;

import org.pitest.functional.F;
import org.pitest.functional.predicate.Predicate;

public abstract class Functions {
    public static F<String, String> classNameToJVMClassName() {
        return new F<String, String>(){

            @Override
            public String apply(String a) {
                return a.replace(".", "/");
            }
        };
    }

    public static F<String, String> jvmClassToClassName() {
        return new F<String, String>(){

            @Override
            public String apply(String a) {
                return a.replace("/", ".");
            }
        };
    }

    public static F<Class<?>, String> classToName() {
        return new F<Class<?>, String>(){

            @Override
            public String apply(Class<?> clazz) {
                return clazz.getName();
            }
        };
    }

    public static Predicate<String> startsWith(final String filter) {
        return new Predicate<String>(){

            @Override
            public Boolean apply(String a) {
                return a.startsWith(filter);
            }
        };
    }

    public static <T extends Enum<T>> F<String, T> stringToEnum(final Class<T> clazz) {
        return new F<String, T>(){

            @Override
            public T apply(String name) {
                return Enum.valueOf(clazz, name);
            }
        };
    }
}

