/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.coverage;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.pitest.classinfo.ClassInfo;
import org.pitest.classinfo.ClassName;
import org.pitest.classpath.CodeSource;
import org.pitest.coverage.BlockCoverage;
import org.pitest.coverage.BlockLocation;
import org.pitest.coverage.ClassLine;
import org.pitest.coverage.CoverageDatabase;
import org.pitest.coverage.CoverageResult;
import org.pitest.coverage.CoverageSummary;
import org.pitest.coverage.LineMap;
import org.pitest.coverage.TestInfo;
import org.pitest.coverage.TestInfoNameComparator;
import org.pitest.functional.F;
import org.pitest.functional.F2;
import org.pitest.functional.FCollection;
import org.pitest.functional.FunctionalList;
import org.pitest.functional.Option;
import org.pitest.functional.predicate.Predicate;
import org.pitest.testapi.Description;
import org.pitest.util.Log;

public class CoverageData
implements CoverageDatabase {
    private static final Logger LOG = Log.getLogger();
    private final Map<BlockLocation, Set<TestInfo>> blockCoverage;
    private final Map<BlockLocation, Set<Integer>> blocksToLines = new LinkedHashMap<BlockLocation, Set<Integer>>();
    private final Map<ClassName, Map<ClassLine, Set<TestInfo>>> lineCoverage = new LinkedHashMap<ClassName, Map<ClassLine, Set<TestInfo>>>();
    private final Map<String, Collection<ClassInfo>> classesForFile;
    private final CodeSource code;
    private final LineMap lm;
    private boolean hasFailedTest = false;

    public CoverageData(CodeSource code, LineMap lm) {
        this(code, lm, new LinkedHashMap<BlockLocation, Set<TestInfo>>());
    }

    public CoverageData(CodeSource code, LineMap lm, Map<BlockLocation, Set<TestInfo>> blockCoverage) {
        this.blockCoverage = blockCoverage;
        this.code = code;
        this.lm = lm;
        this.classesForFile = FCollection.bucket((Iterable)this.code.getCode(), CoverageData.keyFromClassInfo());
    }

    @Override
    public Collection<TestInfo> getTestsForClassLine(ClassLine classLine) {
        Collection result = this.getTestsForClassName(classLine.getClassName()).get(classLine);
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    public boolean allTestsGreen() {
        return !this.hasFailedTest;
    }

    @Override
    public Collection<ClassInfo> getClassInfo(Collection<ClassName> classes) {
        return this.code.getClassInfo(classes);
    }

    @Override
    public int getNumberOfCoveredLines(Collection<ClassName> mutatedClass) {
        return (Integer)FCollection.fold(this.numberCoveredLines(), (Object)0, mutatedClass);
    }

    @Override
    public Collection<TestInfo> getTestsForClass(ClassName clazz) {
        TreeSet<TestInfo> tis = new TreeSet<TestInfo>((Comparator<TestInfo>)new TestInfoNameComparator());
        tis.addAll((Collection<TestInfo>)FCollection.filter(this.blockCoverage.entrySet(), this.isFor(clazz)).flatMap(this.toTests()));
        return tis;
    }

    public void calculateClassCoverage(CoverageResult cr) {
        this.checkForFailedTest(cr);
        TestInfo ti = this.createTestInfo(cr.getTestUnitDescription(), cr.getExecutionTime(), cr.getNumberOfCoveredBlocks());
        for (BlockLocation each : cr.getCoverage()) {
            this.addTestsToBlockMap(ti, each);
        }
    }

    private void addTestsToBlockMap(TestInfo ti, BlockLocation each) {
        Set<TestInfo> tests = this.blockCoverage.get(each);
        if (tests == null) {
            tests = new TreeSet<TestInfo>((Comparator<TestInfo>)new TestInfoNameComparator());
            this.blockCoverage.put(each, tests);
        }
        tests.add(ti);
    }

    @Override
    public BigInteger getCoverageIdForClass(ClassName clazz) {
        Map<ClassLine, Set<TestInfo>> coverage = this.getTestsForClassName(clazz);
        if (coverage.isEmpty()) {
            return BigInteger.ZERO;
        }
        return this.generateCoverageNumber(coverage);
    }

    public List<BlockCoverage> createCoverage() {
        return FCollection.map(this.blockCoverage.entrySet(), CoverageData.toBlockCoverage());
    }

    private static F<Map.Entry<BlockLocation, Set<TestInfo>>, BlockCoverage> toBlockCoverage() {
        return new F<Map.Entry<BlockLocation, Set<TestInfo>>, BlockCoverage>(){

            public BlockCoverage apply(Map.Entry<BlockLocation, Set<TestInfo>> a) {
                return new BlockCoverage(a.getKey(), (Collection)FCollection.map((Iterable)a.getValue(), (F)TestInfo.toName()));
            }
        };
    }

    @Override
    public Collection<ClassInfo> getClassesForFile(String sourceFile, String packageName) {
        Collection<ClassInfo> value = this.getClassesForFileCache().get(CoverageData.keyFromSourceAndPackage(sourceFile, packageName));
        if (value == null) {
            return Collections.emptyList();
        }
        return value;
    }

    private Map<String, Collection<ClassInfo>> getClassesForFileCache() {
        return this.classesForFile;
    }

    @Override
    public CoverageSummary createSummary() {
        return new CoverageSummary(this.numberOfLines(), this.coveredLines());
    }

    private BigInteger generateCoverageNumber(Map<ClassLine, Set<TestInfo>> coverage) {
        BigInteger coverageNumber = BigInteger.ZERO;
        HashSet testClasses = new HashSet();
        FCollection.flatMapTo(coverage.values(), this.testsToClassName(), testClasses);
        for (ClassInfo each : this.code.getClassInfo(testClasses)) {
            coverageNumber = coverageNumber.add(each.getDeepHash());
        }
        return coverageNumber;
    }

    private F<Set<TestInfo>, Iterable<ClassName>> testsToClassName() {
        return new F<Set<TestInfo>, Iterable<ClassName>>(){

            public Iterable<ClassName> apply(Set<TestInfo> a) {
                return FCollection.map(a, (F)TestInfo.toDefiningClassName());
            }
        };
    }

    private static F<ClassInfo, String> keyFromClassInfo() {
        return new F<ClassInfo, String>(){

            public String apply(ClassInfo c) {
                return CoverageData.keyFromSourceAndPackage(c.getSourceFileName(), c.getName().getPackage().asJavaName());
            }
        };
    }

    private static String keyFromSourceAndPackage(String sourceFile, String packageName) {
        return packageName + " " + sourceFile;
    }

    private Collection<ClassName> allClasses() {
        return this.code.getCodeUnderTestNames();
    }

    private int numberOfLines() {
        return (Integer)FCollection.fold(this.numberLines(), (Object)0, (Iterable)this.code.getClassInfo(this.allClasses()));
    }

    private int coveredLines() {
        return (Integer)FCollection.fold(this.numberCoveredLines(), (Object)0, this.allClasses());
    }

    private F2<Integer, ClassInfo, Integer> numberLines() {
        return new F2<Integer, ClassInfo, Integer>(){

            public Integer apply(Integer a, ClassInfo clazz) {
                return a + clazz.getNumberOfCodeLines();
            }
        };
    }

    private void checkForFailedTest(CoverageResult cr) {
        if (!cr.isGreenTest()) {
            this.recordTestFailure();
            LOG.severe(cr.getTestUnitDescription() + " did not pass without mutation.");
        }
    }

    private TestInfo createTestInfo(Description description, int executionTime, int linesCovered) {
        Option testee = this.code.findTestee(description.getFirstTestClass());
        return new TestInfo(description.getFirstTestClass(), description.getQualifiedName(), executionTime, testee, linesCovered);
    }

    private F2<Integer, ClassName, Integer> numberCoveredLines() {
        return new F2<Integer, ClassName, Integer>(){

            public Integer apply(Integer a, ClassName clazz) {
                return a + CoverageData.this.getNumberOfCoveredLines(clazz);
            }
        };
    }

    private int getNumberOfCoveredLines(ClassName clazz) {
        Map<ClassLine, Set<TestInfo>> map = this.getTestsForClassName(clazz);
        if (map != null) {
            return map.size();
        }
        return 0;
    }

    private Map<ClassLine, Set<TestInfo>> getTestsForClassName(ClassName clazz) {
        Map<ClassLine, Set<TestInfo>> map = this.lineCoverage.get(clazz);
        if (map != null) {
            return map;
        }
        return this.convertBlockCoverageToLineCoverageForClass(clazz);
    }

    private Map<ClassLine, Set<TestInfo>> convertBlockCoverageToLineCoverageForClass(ClassName clazz) {
        FunctionalList tests = FCollection.filter(this.blockCoverage.entrySet(), this.isFor(clazz));
        LinkedHashMap<ClassLine, Set<TestInfo>> linesToTests = new LinkedHashMap<ClassLine, Set<TestInfo>>(0);
        for (Map.Entry each : tests) {
            for (int line : this.getLinesForBlock((BlockLocation)each.getKey())) {
                Set<TestInfo> tis = CoverageData.getLineTestSet(clazz, linesToTests, each, line);
                tis.addAll((Collection)each.getValue());
            }
        }
        this.lineCoverage.put(clazz, linesToTests);
        return linesToTests;
    }

    private static Set<TestInfo> getLineTestSet(ClassName clazz, Map<ClassLine, Set<TestInfo>> linesToTests, Map.Entry<BlockLocation, Set<TestInfo>> each, int line) {
        ClassLine cl = new ClassLine(clazz, line);
        Set<TestInfo> tis = linesToTests.get(cl);
        if (tis == null) {
            tis = new TreeSet<TestInfo>((Comparator<TestInfo>)new TestInfoNameComparator());
            tis.addAll((Collection<TestInfo>)each.getValue());
            linesToTests.put(new ClassLine(clazz, line), tis);
        }
        return tis;
    }

    private Set<Integer> getLinesForBlock(BlockLocation bl) {
        Set<Integer> lines = this.blocksToLines.get(bl);
        if (lines == null) {
            this.calculateLinesForBlocks(bl.getLocation().getClassName());
            lines = this.blocksToLines.get(bl);
            if (lines == null) {
                lines = Collections.emptySet();
            }
        }
        return lines;
    }

    private void calculateLinesForBlocks(ClassName className) {
        Map lines = this.lm.mapLines(className);
        this.blocksToLines.putAll(lines);
    }

    private void recordTestFailure() {
        this.hasFailedTest = true;
    }

    private F<Map.Entry<BlockLocation, Set<TestInfo>>, Iterable<TestInfo>> toTests() {
        return new F<Map.Entry<BlockLocation, Set<TestInfo>>, Iterable<TestInfo>>(){

            public Iterable<TestInfo> apply(Map.Entry<BlockLocation, Set<TestInfo>> a) {
                return a.getValue();
            }
        };
    }

    private Predicate<Map.Entry<BlockLocation, Set<TestInfo>>> isFor(final ClassName clazz) {
        return new Predicate<Map.Entry<BlockLocation, Set<TestInfo>>>(){

            public Boolean apply(Map.Entry<BlockLocation, Set<TestInfo>> a) {
                return a.getKey().isFor(clazz);
            }
        };
    }
}

