/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.equivalent;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.bytecode.analysis.MethodMatchers;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.prelude.Prelude;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.engine.gregor.mutators.BooleanTrueReturnValsMutator;

class HardCodedTrueEquivalentFilter
implements MutationInterceptor {
    private static final Set<String> MUTATOR_IDS = new HashSet<String>();
    private static final Set<Integer> TRUE_CONSTANTS = new HashSet<Integer>();
    private ClassTree currentClass;

    HardCodedTrueEquivalentFilter() {
    }

    @Override
    public InterceptorType type() {
        return InterceptorType.FILTER;
    }

    @Override
    public void begin(ClassTree clazz) {
        this.currentClass = clazz;
    }

    @Override
    public Collection<MutationDetails> intercept(Collection<MutationDetails> mutations, Mutater m) {
        return FCollection.filter(mutations, (F)Prelude.not(this.isEquivalent(m)));
    }

    private F<MutationDetails, Boolean> isEquivalent(Mutater m) {
        return new F<MutationDetails, Boolean>(){

            public Boolean apply(MutationDetails a) {
                MethodTree method;
                if (!MUTATOR_IDS.contains(a.getMutator())) {
                    return false;
                }
                int instruction = a.getInstructionIndex();
                return this.primitiveTrue(instruction, method = (MethodTree)HardCodedTrueEquivalentFilter.this.currentClass.methods().findFirst(MethodMatchers.forLocation(a.getId().getLocation())).value()) || this.boxedTrue(instruction, method);
            }

            private boolean primitiveTrue(int instruction, MethodTree method) {
                return ((AbstractInsnNode)method.instructions().get(instruction - 1)).getOpcode() == 4;
            }

            private boolean boxedTrue(int instruction, MethodTree method) {
                return ((AbstractInsnNode)method.instructions().get(instruction - 2)).getOpcode() == 4 && HardCodedTrueEquivalentFilter.this.isValueOfCall(instruction - 1, method);
            }
        };
    }

    @Override
    public void end() {
        this.currentClass = null;
    }

    private boolean isValueOfCall(int instruction, MethodTree method) {
        AbstractInsnNode abstractInsnNode = (AbstractInsnNode)method.instructions().get(instruction);
        if (abstractInsnNode instanceof MethodInsnNode) {
            return ((MethodInsnNode)abstractInsnNode).name.equals("valueOf");
        }
        return false;
    }

    static {
        TRUE_CONSTANTS.add(4);
        MUTATOR_IDS.add(BooleanTrueReturnValsMutator.BOOLEAN_TRUE_RETURN.getGloballyUniqueId());
    }
}

