/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.logging;

import java.util.Set;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;

class LoggingLineScanner
extends MethodVisitor {
    private final Set<Integer> lines;
    private final Set<String> loggingClasses;
    private int currentLineNumber;

    LoggingLineScanner(Set<Integer> lines, Set<String> loggingClasses) {
        super(393216);
        this.lines = lines;
        this.loggingClasses = loggingClasses;
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (FCollection.contains(this.loggingClasses, LoggingLineScanner.matches(owner))) {
            this.lines.add(this.currentLineNumber);
        }
    }

    private static F<String, Boolean> matches(final String owner) {
        return new F<String, Boolean>(){

            public Boolean apply(String a) {
                return owner.startsWith(a);
            }
        };
    }

    @Override
    public void visitLineNumber(int line, Label start) {
        this.currentLineNumber = line;
    }
}

