/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import org.pitest.classpath.ClassFilter;
import org.pitest.classpath.ClassPath;
import org.pitest.classpath.ClassPathRoot;
import org.pitest.classpath.PathFilter;
import org.pitest.classpath.ProjectClassPaths;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.Option;
import org.pitest.functional.predicate.And;
import org.pitest.functional.predicate.Predicate;
import org.pitest.functional.prelude.Prelude;
import org.pitest.help.Help;
import org.pitest.help.PitHelpError;
import org.pitest.mutationtest.config.DatedDirectoryReportDirCreationStrategy;
import org.pitest.mutationtest.config.DefaultCodePathPredicate;
import org.pitest.mutationtest.config.DefaultDependencyPathPredicate;
import org.pitest.mutationtest.config.DirectoryResultOutputStrategy;
import org.pitest.mutationtest.config.PathNamePredicate;
import org.pitest.mutationtest.config.ReportDirCreationStrategy;
import org.pitest.mutationtest.config.TestPluginArguments;
import org.pitest.mutationtest.config.UndatedReportDirCreationStrategy;
import org.pitest.mutationtest.incremental.FileWriterFactory;
import org.pitest.mutationtest.incremental.NullWriterFactory;
import org.pitest.mutationtest.incremental.WriterFactory;
import org.pitest.testapi.TestGroupConfig;
import org.pitest.testapi.execute.Pitest;
import org.pitest.util.Glob;
import org.pitest.util.ResultOutputStrategy;
import org.pitest.util.Unchecked;

public class ReportOptions {
    public static final Collection<String> LOGGING_CLASSES = Arrays.asList("java.util.logging", "org.apache.log4j", "org.apache.logging.log4j", "org.slf4j", "org.apache.commons.logging");
    private Collection<String> targetClasses;
    private Collection<String> excludedMethods = Collections.emptyList();
    private Collection<String> excludedClasses = Collections.emptyList();
    private Collection<Predicate<String>> excludedTestClasses = Collections.emptyList();
    private Collection<String> codePaths;
    private String reportDir;
    private File historyInputLocation;
    private File historyOutputLocation;
    private Collection<File> sourceDirs;
    private Collection<String> classPathElements;
    private Collection<String> mutators;
    private Collection<String> features;
    private int dependencyAnalysisMaxDistance;
    private final List<String> jvmArgs = new ArrayList<String>();
    private int numberOfThreads = 0;
    private float timeoutFactor = 1.25f;
    private long timeoutConstant = 4000L;
    private Collection<Predicate<String>> targetTests;
    private Collection<String> loggingClasses = new ArrayList<String>();
    private int maxMutationsPerClass;
    private boolean verbose = false;
    private boolean failWhenNoMutations = false;
    private final Collection<String> outputs = new LinkedHashSet<String>();
    private TestGroupConfig groupConfig;
    private int mutationUnitSize;
    private boolean shouldCreateTimestampedReports = true;
    private boolean detectInlinedCode = false;
    private boolean exportLineCoverage = false;
    private int mutationThreshold;
    private int coverageThreshold;
    private String mutationEngine = "gregor";
    private String javaExecutable;
    private boolean includeLaunchClasspath = true;
    private Properties properties;
    private int maxSurvivors;
    private Collection<String> excludedRunners = new ArrayList<String>();
    private Collection<String> includedTestMethods = new ArrayList<String>();
    private String testPlugin = "";

    public boolean isVerbose() {
        return this.verbose;
    }

    public String getReportDir() {
        return this.reportDir;
    }

    public void setReportDir(String reportDir) {
        this.reportDir = reportDir;
    }

    public Collection<File> getSourceDirs() {
        return this.sourceDirs;
    }

    public Collection<String> getClassPathElements() {
        return this.classPathElements;
    }

    public void setClassPathElements(Collection<String> classPathElements) {
        this.classPathElements = classPathElements;
    }

    public void setSourceDirs(Collection<File> sourceDirs) {
        this.sourceDirs = sourceDirs;
    }

    public Collection<String> getMutators() {
        return this.mutators;
    }

    public void setMutators(Collection<String> mutators) {
        this.mutators = mutators;
    }

    public Collection<String> getFeatures() {
        return this.features;
    }

    public void setFeatures(Collection<String> features) {
        this.features = features;
    }

    public int getDependencyAnalysisMaxDistance() {
        return this.dependencyAnalysisMaxDistance;
    }

    public void setDependencyAnalysisMaxDistance(int dependencyAnalysisMaxDistance) {
        this.dependencyAnalysisMaxDistance = dependencyAnalysisMaxDistance;
    }

    public List<String> getJvmArgs() {
        return this.jvmArgs;
    }

    public void addChildJVMArgs(List<String> args) {
        this.jvmArgs.addAll(args);
    }

    public ClassPath getClassPath() {
        if (this.classPathElements != null) {
            return this.createClassPathFromElements();
        }
        return new ClassPath();
    }

    private ClassPath createClassPathFromElements() {
        return new ClassPath((Collection)FCollection.map(this.classPathElements, ReportOptions.stringToFile()));
    }

    private static F<String, File> stringToFile() {
        return new F<String, File>(){

            public File apply(String a) {
                return new File(a);
            }
        };
    }

    public Collection<String> getTargetClasses() {
        return this.targetClasses;
    }

    public Predicate<String> getTargetClassesFilter() {
        And filter = Prelude.and((F[])new F[]{Prelude.or((Iterable)Glob.toGlobPredicates(this.targetClasses)), Prelude.not(ReportOptions.isBlackListed(Glob.toGlobPredicates(this.excludedClasses)))});
        this.checkNotTryingToMutateSelf((Predicate<String>)filter);
        return filter;
    }

    private void checkNotTryingToMutateSelf(Predicate<String> filter) {
        if (((Boolean)filter.apply((Object)Pitest.class.getName())).booleanValue()) {
            throw new PitHelpError(Help.BAD_FILTER, new Object[0]);
        }
    }

    public void setTargetClasses(Collection<String> targetClasses) {
        this.targetClasses = targetClasses;
    }

    public void setTargetTests(Collection<Predicate<String>> targetTestsPredicates) {
        this.targetTests = targetTestsPredicates;
    }

    public int getNumberOfThreads() {
        return this.numberOfThreads;
    }

    public void setNumberOfThreads(int numberOfThreads) {
        this.numberOfThreads = numberOfThreads;
    }

    public float getTimeoutFactor() {
        return this.timeoutFactor;
    }

    public long getTimeoutConstant() {
        return this.timeoutConstant;
    }

    public void setTimeoutConstant(long timeoutConstant) {
        this.timeoutConstant = timeoutConstant;
    }

    public void setTimeoutFactor(float timeoutFactor) {
        this.timeoutFactor = timeoutFactor;
    }

    public Collection<Predicate<String>> getTargetTests() {
        return this.targetTests;
    }

    public Predicate<String> getTargetTestsFilter() {
        if (this.targetTests == null || this.targetTests.isEmpty()) {
            return Prelude.and((F[])new F[]{Prelude.or((Iterable)Glob.toGlobPredicates(this.targetClasses)), Prelude.not(ReportOptions.isBlackListed(this.excludedTestClasses))});
        }
        return Prelude.and((F[])new F[]{Prelude.or(this.targetTests), Prelude.not(ReportOptions.isBlackListed(this.excludedTestClasses))});
    }

    private static Predicate<String> isBlackListed(Collection<Predicate<String>> excludedClasses) {
        return Prelude.or(excludedClasses);
    }

    public Collection<String> getLoggingClasses() {
        if (this.loggingClasses.isEmpty()) {
            return LOGGING_CLASSES;
        }
        return this.loggingClasses;
    }

    public void setLoggingClasses(Collection<String> loggingClasses) {
        this.loggingClasses = loggingClasses;
    }

    public Collection<String> getExcludedMethods() {
        return this.excludedMethods;
    }

    public void setExcludedMethods(Collection<String> excludedMethods) {
        this.excludedMethods = excludedMethods;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setExcludedClasses(Collection<String> excludedClasses) {
        this.excludedClasses = excludedClasses;
    }

    public void setExcludedTestClasses(Collection<Predicate<String>> excludedClasses) {
        this.excludedTestClasses = excludedClasses;
    }

    public void addOutputFormats(Collection<String> formats) {
        this.outputs.addAll(formats);
    }

    public Collection<String> getOutputFormats() {
        return this.outputs;
    }

    public Collection<String> getExcludedClasses() {
        return this.excludedClasses;
    }

    public Collection<Predicate<String>> getExcludedTestClasses() {
        return this.excludedTestClasses;
    }

    public boolean shouldFailWhenNoMutations() {
        return this.failWhenNoMutations;
    }

    public void setFailWhenNoMutations(boolean failWhenNoMutations) {
        this.failWhenNoMutations = failWhenNoMutations;
    }

    public ProjectClassPaths getMutationClassPaths() {
        return new ProjectClassPaths(this.getClassPath(), this.createClassesFilter(), this.createPathFilter());
    }

    public ClassFilter createClassesFilter() {
        return new ClassFilter(this.getTargetTestsFilter(), this.getTargetClassesFilter());
    }

    private PathFilter createPathFilter() {
        return new PathFilter(this.createCodePathFilter(), (Predicate)Prelude.not((F)new DefaultDependencyPathPredicate()));
    }

    private Predicate<ClassPathRoot> createCodePathFilter() {
        if (this.codePaths != null && !this.codePaths.isEmpty()) {
            return new PathNamePredicate((Predicate<String>)Prelude.or((Iterable)Glob.toGlobPredicates(this.codePaths)));
        }
        return new DefaultCodePathPredicate();
    }

    public Collection<String> getCodePaths() {
        return this.codePaths;
    }

    public void setCodePaths(Collection<String> codePaths) {
        this.codePaths = codePaths;
    }

    public void setGroupConfig(TestGroupConfig groupConfig) {
        this.groupConfig = groupConfig;
    }

    public TestGroupConfig getGroupConfig() {
        return this.groupConfig;
    }

    public int getMutationUnitSize() {
        return this.mutationUnitSize;
    }

    public void setMutationUnitSize(int size) {
        this.mutationUnitSize = size;
    }

    public ResultOutputStrategy getReportDirectoryStrategy() {
        return new DirectoryResultOutputStrategy(this.getReportDir(), this.pickDirectoryStrategy());
    }

    public void setShouldCreateTimestampedReports(boolean shouldCreateTimestampedReports) {
        this.shouldCreateTimestampedReports = shouldCreateTimestampedReports;
    }

    private ReportDirCreationStrategy pickDirectoryStrategy() {
        if (this.shouldCreateTimestampedReports) {
            return new DatedDirectoryReportDirCreationStrategy();
        }
        return new UndatedReportDirCreationStrategy();
    }

    public boolean shouldCreateTimeStampedReports() {
        return this.shouldCreateTimestampedReports;
    }

    public boolean isDetectInlinedCode() {
        return this.detectInlinedCode;
    }

    public void setDetectInlinedCode(boolean b) {
        this.detectInlinedCode = b;
    }

    public WriterFactory createHistoryWriter() {
        if (this.historyOutputLocation == null) {
            return new NullWriterFactory();
        }
        return new FileWriterFactory(this.historyOutputLocation);
    }

    public Option<Reader> createHistoryReader() {
        if (this.historyInputLocation == null) {
            return Option.none();
        }
        try {
            if (this.historyInputLocation.exists() && this.historyInputLocation.length() > 0L) {
                return Option.some((Object)new InputStreamReader((InputStream)new FileInputStream(this.historyInputLocation), "UTF-8"));
            }
            return Option.none();
        }
        catch (IOException ex) {
            throw Unchecked.translateCheckedException((Throwable)ex);
        }
    }

    public void setHistoryInputLocation(File historyInputLocation) {
        this.historyInputLocation = historyInputLocation;
    }

    public void setHistoryOutputLocation(File historyOutputLocation) {
        this.historyOutputLocation = historyOutputLocation;
    }

    public File getHistoryInputLocation() {
        return this.historyInputLocation;
    }

    public File getHistoryOutputLocation() {
        return this.historyOutputLocation;
    }

    public void setExportLineCoverage(boolean value) {
        this.exportLineCoverage = value;
    }

    public boolean shouldExportLineCoverage() {
        return this.exportLineCoverage;
    }

    public int getMutationThreshold() {
        return this.mutationThreshold;
    }

    public void setMutationThreshold(int value) {
        this.mutationThreshold = value;
    }

    public String getMutationEngine() {
        return this.mutationEngine;
    }

    public void setMutationEngine(String mutationEngine) {
        this.mutationEngine = mutationEngine;
    }

    public int getCoverageThreshold() {
        return this.coverageThreshold;
    }

    public void setCoverageThreshold(int coverageThreshold) {
        this.coverageThreshold = coverageThreshold;
    }

    public String getJavaExecutable() {
        return this.javaExecutable;
    }

    public void setJavaExecutable(String javaExecutable) {
        this.javaExecutable = javaExecutable;
    }

    public void setIncludeLaunchClasspath(boolean b) {
        this.includeLaunchClasspath = b;
    }

    public boolean isIncludeLaunchClasspath() {
        return this.includeLaunchClasspath;
    }

    public Properties getFreeFormProperties() {
        return this.properties;
    }

    public void setFreeFormProperties(Properties props) {
        this.properties = props;
    }

    public int getMaximumAllowedSurvivors() {
        return this.maxSurvivors;
    }

    public void setMaximumAllowedSurvivors(int maxSurvivors) {
        this.maxSurvivors = maxSurvivors;
    }

    public Collection<String> getExcludedRunners() {
        return this.excludedRunners;
    }

    public Collection<String> getIncludedTestMethods() {
        return this.includedTestMethods;
    }

    public void setExcludedRunners(Collection<String> excludedRunners) {
        this.excludedRunners = excludedRunners;
    }

    public void setIncludedTestMethods(Collection<String> includedTestMethods) {
        this.includedTestMethods = includedTestMethods;
    }

    public TestPluginArguments createMinionSettings() {
        return new TestPluginArguments(this.getTestPlugin(), this.getGroupConfig(), this.getExcludedRunners(), this.getIncludedTestMethods());
    }

    public String getTestPlugin() {
        return this.testPlugin;
    }

    public void setTestPlugin(String testPlugin) {
        this.testPlugin = testPlugin;
    }

    public String toString() {
        return "ReportOptions [targetClasses=" + this.targetClasses + ", excludedMethods=" + this.excludedMethods + ", excludedClasses=" + this.excludedClasses + ", excludedTestClasses=" + this.excludedTestClasses + ", codePaths=" + this.codePaths + ", reportDir=" + this.reportDir + ", historyInputLocation=" + this.historyInputLocation + ", historyOutputLocation=" + this.historyOutputLocation + ", sourceDirs=" + this.sourceDirs + ", classPathElements=" + this.classPathElements + ", mutators=" + this.mutators + ", features=" + this.features + ", dependencyAnalysisMaxDistance=" + this.dependencyAnalysisMaxDistance + ", jvmArgs=" + this.jvmArgs + ", numberOfThreads=" + this.numberOfThreads + ", timeoutFactor=" + this.timeoutFactor + ", timeoutConstant=" + this.timeoutConstant + ", targetTests=" + this.targetTests + ", loggingClasses=" + this.loggingClasses + ", maxMutationsPerClass=" + this.maxMutationsPerClass + ", verbose=" + this.verbose + ", failWhenNoMutations=" + this.failWhenNoMutations + ", outputs=" + this.outputs + ", groupConfig=" + this.groupConfig + ", mutationUnitSize=" + this.mutationUnitSize + ", shouldCreateTimestampedReports=" + this.shouldCreateTimestampedReports + ", detectInlinedCode=" + this.detectInlinedCode + ", exportLineCoverage=" + this.exportLineCoverage + ", mutationThreshold=" + this.mutationThreshold + ", coverageThreshold=" + this.coverageThreshold + ", mutationEngine=" + this.mutationEngine + ", javaExecutable=" + this.javaExecutable + ", includeLaunchClasspath=" + this.includeLaunchClasspath + ", properties=" + this.properties + ", maxSurvivors=" + this.maxSurvivors + ", excludedRunners=" + this.excludedRunners + ", testPlugin=" + this.testPlugin + ", includedTestMethods=" + this.includedTestMethods + "]";
    }
}

