/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.pitest.coverage.CoverageExporter;
import org.pitest.coverage.execute.CoverageOptions;
import org.pitest.coverage.export.DefaultCoverageExporter;
import org.pitest.coverage.export.NullCoverageExporter;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.FunctionalList;
import org.pitest.functional.SideEffect1;
import org.pitest.functional.predicate.Predicate;
import org.pitest.mutationtest.MutationEngineFactory;
import org.pitest.mutationtest.MutationResultListenerFactory;
import org.pitest.mutationtest.build.CompoundInterceptorFactory;
import org.pitest.mutationtest.build.DefaultMutationGrouperFactory;
import org.pitest.mutationtest.build.DefaultTestPrioritiserFactory;
import org.pitest.mutationtest.build.MutationGrouperFactory;
import org.pitest.mutationtest.build.MutationInterceptorFactory;
import org.pitest.mutationtest.build.TestPrioritiserFactory;
import org.pitest.mutationtest.config.CompoundListenerFactory;
import org.pitest.mutationtest.config.PluginServices;
import org.pitest.mutationtest.config.ReportOptions;
import org.pitest.plugin.Feature;
import org.pitest.plugin.FeatureParser;
import org.pitest.plugin.FeatureSelector;
import org.pitest.plugin.ProvidesFeature;
import org.pitest.process.DefaultJavaExecutableLocator;
import org.pitest.process.JavaExecutableLocator;
import org.pitest.process.KnownLocationJavaExecutableLocator;
import org.pitest.util.PitError;
import org.pitest.util.ResultOutputStrategy;
import org.pitest.util.StringUtil;

public class SettingsFactory {
    private final ReportOptions options;
    private final PluginServices plugins;

    public SettingsFactory(ReportOptions options, PluginServices plugins) {
        this.options = options;
        this.plugins = plugins;
    }

    public ResultOutputStrategy getOutputStrategy() {
        return this.options.getReportDirectoryStrategy();
    }

    public CoverageExporter createCoverageExporter() {
        if (this.options.shouldExportLineCoverage()) {
            return new DefaultCoverageExporter(this.getOutputStrategy());
        }
        return new NullCoverageExporter();
    }

    public MutationEngineFactory createEngine() {
        for (MutationEngineFactory mutationEngineFactory : this.plugins.findMutationEngines()) {
            if (!mutationEngineFactory.name().equals(this.options.getMutationEngine())) continue;
            return mutationEngineFactory;
        }
        throw new PitError("Could not load requested engine " + this.options.getMutationEngine());
    }

    public MutationResultListenerFactory createListener() {
        return new CompoundListenerFactory(this.findListeners());
    }

    public JavaExecutableLocator getJavaExecutable() {
        if (this.options.getJavaExecutable() != null) {
            return new KnownLocationJavaExecutableLocator(this.options.getJavaExecutable());
        }
        return new DefaultJavaExecutableLocator();
    }

    public MutationGrouperFactory getMutationGrouper() {
        Collection<? extends MutationGrouperFactory> groupers = this.plugins.findGroupers();
        return SettingsFactory.firstOrDefault(groupers, new DefaultMutationGrouperFactory());
    }

    public void describeFeatures(SideEffect1<Feature> enabled, SideEffect1<Feature> disabled) {
        FeatureParser parser = new FeatureParser();
        ArrayList<? extends MutationInterceptorFactory> available = new ArrayList<MutationInterceptorFactory>(this.plugins.findInterceptors());
        List settings = parser.parseFeatures(this.options.getFeatures());
        FeatureSelector selector = new FeatureSelector(settings, available);
        HashSet enabledFeatures = new HashSet();
        FCollection.mapTo((Iterable)selector.getActiveFeatures(), SettingsFactory.toFeature(), enabledFeatures);
        FCollection.forEach(enabledFeatures, enabled);
        HashSet disabledFeatures = new HashSet();
        FCollection.mapTo(available, SettingsFactory.toFeature(), disabledFeatures);
        disabledFeatures.removeAll(enabledFeatures);
        FCollection.forEach(disabledFeatures, disabled);
    }

    public TestPrioritiserFactory getTestPrioritiser() {
        Collection<? extends TestPrioritiserFactory> testPickers = this.plugins.findTestPrioritisers();
        return SettingsFactory.firstOrDefault(testPickers, new DefaultTestPrioritiserFactory());
    }

    public CoverageOptions createCoverageOptions() {
        return new CoverageOptions(this.options.getTargetClasses(), this.options.getExcludedClasses(), this.options.createMinionSettings(), this.options.isVerbose(), this.options.getDependencyAnalysisMaxDistance());
    }

    public CompoundInterceptorFactory getInterceptor() {
        Collection<? extends MutationInterceptorFactory> interceptors = this.plugins.findInterceptors();
        FeatureParser parser = new FeatureParser();
        return new CompoundInterceptorFactory(parser.parseFeatures(this.options.getFeatures()), new ArrayList<MutationInterceptorFactory>(interceptors));
    }

    private static F<MutationResultListenerFactory, Boolean> nameMatches(final Iterable<String> outputFormats) {
        return new F<MutationResultListenerFactory, Boolean>(){

            public Boolean apply(MutationResultListenerFactory a) {
                return FCollection.contains((Iterable)outputFormats, (F)SettingsFactory.equalsIgnoreCase(a.name()));
            }
        };
    }

    private Iterable<MutationResultListenerFactory> findListeners() {
        Collection<? extends MutationResultListenerFactory> listeners = this.plugins.findListeners();
        FunctionalList matches = FCollection.filter(listeners, SettingsFactory.nameMatches(this.options.getOutputFormats()));
        if (matches.size() < this.options.getOutputFormats().size()) {
            throw new PitError("Unknown listener requested in " + StringUtil.join(this.options.getOutputFormats(), (String)","));
        }
        return matches;
    }

    private static Predicate<String> equalsIgnoreCase(final String other) {
        return new Predicate<String>(){

            public Boolean apply(String a) {
                return a.equalsIgnoreCase(other);
            }
        };
    }

    private static <T> T firstOrDefault(Collection<? extends T> found, T defaultInstance) {
        if (found.isEmpty()) {
            return defaultInstance;
        }
        if (found.size() > 1) {
            throw new PitError("Multiple implementations of plugin detected on classpath");
        }
        return found.iterator().next();
    }

    private static F<ProvidesFeature, Feature> toFeature() {
        return new F<ProvidesFeature, Feature>(){

            public Feature apply(ProvidesFeature a) {
                return a.provides();
            }
        };
    }
}

