/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.statistics;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.pitest.functional.F;
import org.pitest.functional.F2;
import org.pitest.functional.FCollection;
import org.pitest.functional.SideEffect1;
import org.pitest.mutationtest.MutationResult;
import org.pitest.mutationtest.statistics.MutationStatistics;
import org.pitest.mutationtest.statistics.Score;
import org.pitest.mutationtest.statistics.ScorePrecursor;

class MutationStatisticsPrecursor {
    private final Map<String, ScorePrecursor> mutatorTotalMap = new HashMap<String, ScorePrecursor>();
    private long numberOfTestsRun = 0L;

    MutationStatisticsPrecursor() {
    }

    public void registerResults(Collection<MutationResult> results) {
        FCollection.forEach(results, this.register());
    }

    private SideEffect1<MutationResult> register() {
        return new SideEffect1<MutationResult>(){

            public void apply(MutationResult mr) {
                MutationStatisticsPrecursor.this.numberOfTestsRun = MutationStatisticsPrecursor.this.numberOfTestsRun + (long)mr.getNumberOfTestsRun();
                String key = mr.getDetails().getId().getMutator();
                ScorePrecursor total = (ScorePrecursor)MutationStatisticsPrecursor.this.mutatorTotalMap.get(key);
                if (total == null) {
                    total = new ScorePrecursor(key);
                    MutationStatisticsPrecursor.this.mutatorTotalMap.put(key, total);
                }
                total.registerResult(mr.getStatus());
            }
        };
    }

    public MutationStatistics toStatistics() {
        Iterable<Score> scores = this.getScores();
        long totalMutations = (Long)FCollection.fold(MutationStatisticsPrecursor.addTotals(), (Object)0L, scores);
        long totalDetected = (Long)FCollection.fold(MutationStatisticsPrecursor.addDetectedTotals(), (Object)0L, scores);
        return new MutationStatistics(scores, totalMutations, totalDetected, this.numberOfTestsRun);
    }

    Iterable<Score> getScores() {
        return FCollection.map(this.mutatorTotalMap.values(), MutationStatisticsPrecursor.toScore());
    }

    private static F<ScorePrecursor, Score> toScore() {
        return new F<ScorePrecursor, Score>(){

            public Score apply(ScorePrecursor a) {
                return a.toScore();
            }
        };
    }

    private static F2<Long, Score, Long> addTotals() {
        return new F2<Long, Score, Long>(){

            public Long apply(Long a, Score b) {
                return a + b.getTotalMutations();
            }
        };
    }

    private static F2<Long, Score, Long> addDetectedTotals() {
        return new F2<Long, Score, Long>(){

            public Long apply(Long a, Score b) {
                return a + b.getTotalDetectedMutations();
            }
        };
    }
}

