/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.tooling;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pitest.classinfo.ClassByteArraySource;
import org.pitest.classinfo.ClassInfo;
import org.pitest.classinfo.ClassName;
import org.pitest.classinfo.HierarchicalClassId;
import org.pitest.classpath.ClassPathByteArraySource;
import org.pitest.classpath.ClassloaderByteArraySource;
import org.pitest.classpath.CodeSource;
import org.pitest.coverage.CoverageDatabase;
import org.pitest.coverage.CoverageGenerator;
import org.pitest.coverage.TestInfo;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.FunctionalList;
import org.pitest.functional.Option;
import org.pitest.help.Help;
import org.pitest.help.PitHelpError;
import org.pitest.mutationtest.EngineArguments;
import org.pitest.mutationtest.HistoryStore;
import org.pitest.mutationtest.ListenerArguments;
import org.pitest.mutationtest.MutationConfig;
import org.pitest.mutationtest.MutationResultListener;
import org.pitest.mutationtest.TimeoutLengthStrategy;
import org.pitest.mutationtest.build.MutationAnalysisUnit;
import org.pitest.mutationtest.build.MutationGrouper;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.build.MutationSource;
import org.pitest.mutationtest.build.MutationTestBuilder;
import org.pitest.mutationtest.build.PercentAndConstantTimeoutStrategy;
import org.pitest.mutationtest.build.TestPrioritiser;
import org.pitest.mutationtest.build.WorkerFactory;
import org.pitest.mutationtest.config.ReportOptions;
import org.pitest.mutationtest.config.SettingsFactory;
import org.pitest.mutationtest.engine.MutationEngine;
import org.pitest.mutationtest.execute.MutationAnalysisExecutor;
import org.pitest.mutationtest.incremental.DefaultCodeHistory;
import org.pitest.mutationtest.incremental.HistoryListener;
import org.pitest.mutationtest.incremental.IncrementalAnalyser;
import org.pitest.mutationtest.statistics.MutationStatisticsListener;
import org.pitest.mutationtest.statistics.Score;
import org.pitest.mutationtest.tooling.CombinedStatistics;
import org.pitest.mutationtest.tooling.MutationStrategies;
import org.pitest.mutationtest.tooling.SmartSourceLocator;
import org.pitest.mutationtest.tooling.SpinnerListener;
import org.pitest.util.Log;
import org.pitest.util.StringUtil;
import org.pitest.util.Timings;

public class MutationCoverage {
    private static final int MB = 0x100000;
    private static final Logger LOG = Log.getLogger();
    private final ReportOptions data;
    private final MutationStrategies strategies;
    private final Timings timings;
    private final CodeSource code;
    private final File baseDir;
    private final SettingsFactory settings;

    public MutationCoverage(MutationStrategies strategies, File baseDir, CodeSource code, ReportOptions data, SettingsFactory settings, Timings timings) {
        this.strategies = strategies;
        this.data = data;
        this.settings = settings;
        this.timings = timings;
        this.code = code;
        this.baseDir = baseDir;
    }

    public CombinedStatistics runReport() throws IOException {
        Log.setVerbose((boolean)this.data.isVerbose());
        Runtime runtime = Runtime.getRuntime();
        if (!this.data.isVerbose()) {
            LOG.info("Verbose logging is disabled. If you encounter an problem please enable it before reporting an issue.");
        }
        LOG.fine("Running report with " + this.data);
        LOG.fine("System class path is " + System.getProperty("java.class.path"));
        LOG.fine("Maximum available memory is " + runtime.maxMemory() / 0x100000L + " mb");
        long t0 = System.currentTimeMillis();
        this.verifyBuildSuitableForMutationTesting();
        this.checkExcludedRunners();
        CoverageDatabase coverageData = this.coverage().calculateCoverage();
        LOG.fine("Used memory after coverage calculation " + (runtime.totalMemory() - runtime.freeMemory()) / 0x100000L + " mb");
        LOG.fine("Free Memory after coverage calculation " + runtime.freeMemory() / 0x100000L + " mb");
        MutationStatisticsListener stats = new MutationStatisticsListener();
        EngineArguments args = EngineArguments.arguments().withExcludedMethods(this.data.getExcludedMethods()).withMutators(this.data.getMutators());
        MutationEngine engine = this.strategies.factory().createEngine(args);
        List<MutationResultListener> config = this.createConfig(t0, coverageData, stats, engine);
        this.history().initialize();
        this.timings.registerStart(Timings.Stage.BUILD_MUTATION_TESTS);
        List<MutationAnalysisUnit> tus = this.buildMutationTests(coverageData, engine, args);
        this.timings.registerEnd(Timings.Stage.BUILD_MUTATION_TESTS);
        LOG.info("Created  " + tus.size() + " mutation test units");
        this.checkMutationsFound(tus);
        this.recordClassPath(coverageData);
        LOG.fine("Used memory before analysis start " + (runtime.totalMemory() - runtime.freeMemory()) / 0x100000L + " mb");
        LOG.fine("Free Memory before analysis start " + runtime.freeMemory() / 0x100000L + " mb");
        MutationAnalysisExecutor mae = new MutationAnalysisExecutor(this.numberOfThreads(), config);
        this.timings.registerStart(Timings.Stage.RUN_MUTATION_TESTS);
        mae.run(tus);
        this.timings.registerEnd(Timings.Stage.RUN_MUTATION_TESTS);
        LOG.info("Completed in " + this.timeSpan(t0));
        this.printStats(stats);
        return new CombinedStatistics(stats.getStatistics(), coverageData.createSummary());
    }

    private void checkExcludedRunners() {
        Collection<String> excludedRunners = this.data.getExcludedRunners();
        if (!excludedRunners.isEmpty()) {
            try {
                Class.forName("org.junit.runner.RunWith");
            }
            catch (ClassNotFoundException e) {
                throw new PitHelpError(Help.NO_JUNIT_EXCLUDE_RUNNERS, new Object[0]);
            }
        }
    }

    private int numberOfThreads() {
        return Math.max(1, this.data.getNumberOfThreads());
    }

    private List<MutationResultListener> createConfig(long t0, CoverageDatabase coverageData, MutationStatisticsListener stats, MutationEngine engine) {
        ArrayList<MutationResultListener> ls = new ArrayList<MutationResultListener>();
        ls.add(stats);
        ListenerArguments args = new ListenerArguments(this.strategies.output(), coverageData, new SmartSourceLocator(this.data.getSourceDirs()), engine, t0);
        MutationResultListener mutationReportListener = this.strategies.listenerFactory().getListener(this.data.getFreeFormProperties(), args);
        ls.add(mutationReportListener);
        ls.add(new HistoryListener(this.history()));
        if (!this.data.isVerbose()) {
            ls.add(new SpinnerListener(System.out));
        }
        return ls;
    }

    private void recordClassPath(CoverageDatabase coverageData) {
        Set<ClassName> allClassNames = this.getAllClassesAndTests(coverageData);
        FunctionalList ids = FCollection.map((Iterable)this.code.getClassInfo(allClassNames), (F)ClassInfo.toFullClassId());
        this.history().recordClassPath((Collection<HierarchicalClassId>)ids, coverageData);
    }

    private Set<ClassName> getAllClassesAndTests(CoverageDatabase coverageData) {
        HashSet<ClassName> names = new HashSet<ClassName>();
        for (ClassName each : this.code.getCodeUnderTestNames()) {
            names.add(each);
            FCollection.mapTo(coverageData.getTestsForClass(each), (F)TestInfo.toDefiningClassName(), names);
        }
        return names;
    }

    private void verifyBuildSuitableForMutationTesting() {
        this.strategies.buildVerifier().verify(this.code);
    }

    private void printStats(MutationStatisticsListener stats) {
        PrintStream ps = System.out;
        ps.println(StringUtil.separatorLine((char)'='));
        ps.println("- Timings");
        ps.println(StringUtil.separatorLine((char)'='));
        this.timings.report(ps);
        ps.println(StringUtil.separatorLine((char)'='));
        ps.println("- Statistics");
        ps.println(StringUtil.separatorLine((char)'='));
        stats.getStatistics().report(ps);
        ps.println(StringUtil.separatorLine((char)'='));
        ps.println("- Mutators");
        ps.println(StringUtil.separatorLine((char)'='));
        for (Score each : stats.getStatistics().getScores()) {
            each.report(ps);
            ps.println(StringUtil.separatorLine());
        }
    }

    private List<MutationAnalysisUnit> buildMutationTests(CoverageDatabase coverageData, MutationEngine engine, EngineArguments args) {
        MutationConfig mutationConfig = new MutationConfig(engine, this.coverage().getLaunchOptions());
        ClassByteArraySource bas = this.fallbackToClassLoader((ClassByteArraySource)new ClassPathByteArraySource(this.data.getClassPath()));
        TestPrioritiser testPrioritiser = this.settings.getTestPrioritiser().makeTestPrioritiser(this.data.getFreeFormProperties(), this.code, coverageData);
        MutationInterceptor interceptor = this.settings.getInterceptor().createInterceptor(this.data, bas);
        MutationSource source = new MutationSource(mutationConfig, testPrioritiser, bas, interceptor);
        IncrementalAnalyser analyser = new IncrementalAnalyser(new DefaultCodeHistory(this.code, this.history()), coverageData);
        WorkerFactory wf = new WorkerFactory(this.baseDir, this.coverage().getConfiguration(), mutationConfig, args, (TimeoutLengthStrategy)new PercentAndConstantTimeoutStrategy(this.data.getTimeoutFactor(), this.data.getTimeoutConstant()), this.data.isVerbose(), this.data.getClassPath().getLocalClassPath());
        MutationGrouper grouper = this.settings.getMutationGrouper().makeFactory(this.data.getFreeFormProperties(), this.code, this.data.getNumberOfThreads(), this.data.getMutationUnitSize());
        MutationTestBuilder builder = new MutationTestBuilder(wf, analyser, source, grouper);
        return builder.createMutationTestUnits(this.code.getCodeUnderTestNames());
    }

    private void checkMutationsFound(List<MutationAnalysisUnit> tus) {
        if (tus.isEmpty()) {
            if (this.data.shouldFailWhenNoMutations()) {
                throw new PitHelpError(Help.NO_MUTATIONS_FOUND, new Object[0]);
            }
            LOG.warning(Help.NO_MUTATIONS_FOUND.toString());
        }
    }

    private String timeSpan(long t0) {
        return "" + (System.currentTimeMillis() - t0) / 1000L + " seconds";
    }

    private CoverageGenerator coverage() {
        return this.strategies.coverage();
    }

    private HistoryStore history() {
        return this.strategies.history();
    }

    private ClassByteArraySource fallbackToClassLoader(final ClassByteArraySource bas) {
        ClassloaderByteArraySource clSource = ClassloaderByteArraySource.fromContext();
        return new ClassByteArraySource((ClassByteArraySource)clSource){
            final /* synthetic */ ClassByteArraySource val$clSource;
            {
                this.val$clSource = classByteArraySource2;
            }

            public Option<byte[]> getBytes(String clazz) {
                Option maybeBytes = bas.getBytes(clazz);
                if (maybeBytes.hasSome()) {
                    return maybeBytes;
                }
                LOG.log(Level.FINE, "Could not find " + clazz + " on classpath for analysis. Falling back to classloader");
                return this.val$clSource.getBytes(clazz);
            }
        };
    }
}

