/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.coverage.analysis;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pitest.classinfo.ClassName;
import org.pitest.classpath.CodeSource;
import org.pitest.coverage.BlockLocation;
import org.pitest.coverage.LineMap;
import org.pitest.coverage.analysis.Block;
import org.pitest.coverage.analysis.ControlFlowAnalyser;
import org.pitest.functional.Option;
import org.pitest.mutationtest.engine.Location;
import org.pitest.mutationtest.engine.MethodName;
import org.pitest.reloc.asm.ClassReader;
import org.pitest.reloc.asm.tree.ClassNode;
import org.pitest.reloc.asm.tree.MethodNode;

public class LineMapper
implements LineMap {
    private final CodeSource source;

    public LineMapper(CodeSource source) {
        this.source = source;
    }

    @Override
    public Map<BlockLocation, Set<Integer>> mapLines(ClassName clazz) {
        HashMap<BlockLocation, Set<Integer>> map = new HashMap<BlockLocation, Set<Integer>>();
        Option<byte[]> maybeBytes = this.source.fetchClassBytes(clazz);
        for (byte[] bytes : maybeBytes) {
            ClassReader cr = new ClassReader(bytes);
            ClassNode classNode = new ClassNode();
            cr.accept(classNode, 8);
            Iterator<MethodNode> iterator = classNode.methods.iterator();
            while (iterator.hasNext()) {
                MethodNode m;
                MethodNode mn = m = iterator.next();
                Location l = Location.location(clazz, MethodName.fromString(mn.name), mn.desc);
                List<Block> blocks = ControlFlowAnalyser.analyze(mn);
                for (int i = 0; i != blocks.size(); ++i) {
                    BlockLocation bl = new BlockLocation(l, i);
                    map.put(bl, blocks.get(i).getLines());
                }
            }
        }
        return map;
    }
}

