/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.util;

import java.util.Collection;
import java.util.regex.Pattern;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.predicate.Predicate;

public class Glob
implements Predicate<String> {
    private final Pattern regex;

    public Glob(String glob) {
        this.regex = glob.startsWith("~") ? Pattern.compile(glob.substring(1)) : Pattern.compile(Glob.convertGlobToRegex(glob));
    }

    public boolean matches(CharSequence seq) {
        return this.regex.matcher(seq).matches();
    }

    public static F<String, Predicate<String>> toGlobPredicate() {
        return new F<String, Predicate<String>>(){

            @Override
            public Glob apply(String glob) {
                return new Glob(glob);
            }
        };
    }

    public static Collection<Predicate<String>> toGlobPredicates(Collection<String> globs) {
        return FCollection.map(globs, Glob.toGlobPredicate());
    }

    private static String convertGlobToRegex(String glob) {
        StringBuilder out = new StringBuilder("^");
        block7: for (int i = 0; i < glob.length(); ++i) {
            char c = glob.charAt(i);
            switch (c) {
                case '$': {
                    out.append("\\$");
                    continue block7;
                }
                case '*': {
                    out.append(".*");
                    continue block7;
                }
                case '?': {
                    out.append('.');
                    continue block7;
                }
                case '.': {
                    out.append("\\.");
                    continue block7;
                }
                case '\\': {
                    out.append("\\\\");
                    continue block7;
                }
                default: {
                    out.append(c);
                }
            }
        }
        out.append('$');
        return out.toString();
    }

    @Override
    public Boolean apply(String value) {
        return this.matches(value);
    }

    public String toString() {
        return this.regex.pattern();
    }
}

