/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.reporters;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.GivenStories;
import org.jbehave.core.model.Lifecycle;
import org.jbehave.core.model.Meta;
import org.jbehave.core.model.Narrative;
import org.jbehave.core.model.OutcomesTable;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.Story;
import org.jbehave.core.model.StoryDuration;
import org.jbehave.core.reporters.StoryReporter;

public class SilentSuccessFilter
implements StoryReporter {
    private final StoryReporter delegate;
    private State runState = State.SILENT;
    private State beforeStoryState = State.SILENT;
    private State afterStoryState = State.SILENT;
    private State scenarioState = State.SILENT;
    private List<Todo> scenarioTodos = new ArrayList<Todo>();
    private boolean givenStory;

    public SilentSuccessFilter(StoryReporter delegate) {
        this.delegate = delegate;
    }

    @Override
    public void dryRun() {
        this.runState = new State(){

            @Override
            public void report() {
                SilentSuccessFilter.this.delegate.dryRun();
            }
        };
        this.runState.report();
    }

    @Override
    public void pendingMethods(final List<String> methods) {
        this.runState = new State(){

            @Override
            public void report() {
                SilentSuccessFilter.this.delegate.pendingMethods(methods);
            }
        };
        this.runState.report();
    }

    @Override
    public void restarted(String step, Throwable cause) {
    }

    @Override
    public void restartedStory(Story story, Throwable cause) {
    }

    @Override
    public void storyCancelled(Story story, StoryDuration storyDuration) {
    }

    @Override
    public void beforeStory(final Story story, final boolean givenStory) {
        this.givenStory = givenStory;
        this.beforeStoryState = new State(){

            @Override
            public void report() {
                SilentSuccessFilter.this.delegate.beforeStory(story, givenStory);
                SilentSuccessFilter.this.beforeStoryState = State.SILENT;
            }
        };
    }

    @Override
    public void narrative(final Narrative narrative) {
        this.beforeStoryState = new State(){

            @Override
            public void report() {
                SilentSuccessFilter.this.delegate.narrative(narrative);
            }
        };
        this.beforeStoryState.report();
    }

    @Override
    public void lifecyle(final Lifecycle lifecycle) {
        this.beforeStoryState = new State(){

            @Override
            public void report() {
                SilentSuccessFilter.this.delegate.lifecyle(lifecycle);
            }
        };
        this.beforeStoryState.report();
    }

    @Override
    public void storyNotAllowed(final Story story, final String filter) {
        this.beforeStoryState = new State(){

            @Override
            public void report() {
                SilentSuccessFilter.this.delegate.storyNotAllowed(story, filter);
            }
        };
        this.beforeStoryState.report();
    }

    @Override
    public void afterStory(boolean givenStory) {
        this.afterStoryState.report();
    }

    @Override
    public void beforeStep(String step) {
    }

    @Override
    public void ignorable(final String step) {
        this.scenarioTodos.add(new Todo(){

            @Override
            public void doNow() {
                SilentSuccessFilter.this.delegate.ignorable(step);
            }
        });
    }

    @Override
    public void comment(final String step) {
        this.scenarioTodos.add(new Todo(){

            @Override
            public void doNow() {
                SilentSuccessFilter.this.delegate.comment(step);
            }
        });
    }

    @Override
    public void failed(final String step, final Throwable cause) {
        this.scenarioTodos.add(new Todo(){

            @Override
            public void doNow() {
                SilentSuccessFilter.this.delegate.failed(step, cause);
            }
        });
        this.setStateToNoisy();
    }

    @Override
    public void failedOutcomes(final String step, final OutcomesTable table) {
        this.scenarioTodos.add(new Todo(){

            @Override
            public void doNow() {
                SilentSuccessFilter.this.delegate.failedOutcomes(step, table);
            }
        });
        this.setStateToNoisy();
    }

    @Override
    public void notPerformed(final String step) {
        this.scenarioTodos.add(new Todo(){

            @Override
            public void doNow() {
                SilentSuccessFilter.this.delegate.notPerformed(step);
            }
        });
        this.setStateToNoisy();
    }

    @Override
    public void pending(final String step) {
        this.scenarioTodos.add(new Todo(){

            @Override
            public void doNow() {
                SilentSuccessFilter.this.delegate.pending(step);
            }
        });
        this.setStateToNoisy();
    }

    @Override
    public void successful(final String step) {
        this.scenarioTodos.add(new Todo(){

            @Override
            public void doNow() {
                SilentSuccessFilter.this.delegate.successful(step);
            }
        });
    }

    @Override
    public void afterScenario() {
        this.scenarioTodos.add(new Todo(){

            @Override
            public void doNow() {
                SilentSuccessFilter.this.delegate.afterScenario();
            }
        });
        this.scenarioState.report();
    }

    @Override
    public void beforeScenario(final String scenarioTitle) {
        this.scenarioTodos = new ArrayList<Todo>();
        this.scenarioTodos.add(new Todo(){

            @Override
            public void doNow() {
                SilentSuccessFilter.this.delegate.beforeScenario(scenarioTitle);
            }
        });
    }

    @Override
    public void scenarioNotAllowed(final Scenario scenario, final String filter) {
        this.scenarioState = new State(){

            @Override
            public void report() {
                SilentSuccessFilter.this.delegate.scenarioNotAllowed(scenario, filter);
            }
        };
        this.scenarioState.report();
    }

    @Override
    public void scenarioMeta(final Meta meta) {
        this.scenarioTodos = new ArrayList<Todo>();
        this.scenarioTodos.add(new Todo(){

            @Override
            public void doNow() {
                SilentSuccessFilter.this.delegate.scenarioMeta(meta);
            }
        });
    }

    @Override
    public void givenStories(final GivenStories givenStories) {
        this.scenarioTodos.add(new Todo(){

            @Override
            public void doNow() {
                SilentSuccessFilter.this.delegate.givenStories(givenStories);
            }
        });
    }

    @Override
    public void givenStories(final List<String> storyPaths) {
        this.scenarioTodos.add(new Todo(){

            @Override
            public void doNow() {
                SilentSuccessFilter.this.delegate.givenStories(storyPaths);
            }
        });
    }

    @Override
    public void beforeExamples(final List<String> steps, final ExamplesTable table) {
        this.scenarioTodos.add(new Todo(){

            @Override
            public void doNow() {
                SilentSuccessFilter.this.delegate.beforeExamples(steps, table);
            }
        });
    }

    @Override
    public void example(final Map<String, String> tableRow) {
        this.scenarioTodos.add(new Todo(){

            @Override
            public void doNow() {
                SilentSuccessFilter.this.delegate.example(tableRow);
            }
        });
    }

    @Override
    public void afterExamples() {
        this.scenarioTodos.add(new Todo(){

            @Override
            public void doNow() {
                SilentSuccessFilter.this.delegate.afterExamples();
            }
        });
    }

    private void setStateToNoisy() {
        this.scenarioState = new State(){

            @Override
            public void report() {
                SilentSuccessFilter.this.beforeStoryState.report();
                for (Todo todo : SilentSuccessFilter.this.scenarioTodos) {
                    todo.doNow();
                }
                SilentSuccessFilter.this.afterStoryState = new State(){

                    @Override
                    public void report() {
                        SilentSuccessFilter.this.delegate.afterStory(SilentSuccessFilter.this.givenStory);
                        SilentSuccessFilter.this.afterStoryState = State.SILENT;
                    }
                };
                SilentSuccessFilter.this.scenarioState = State.SILENT;
            }
        };
    }

    private static interface State {
        public static final State SILENT = new State(){

            @Override
            public void report() {
            }
        };

        public void report();
    }

    private static interface Todo {
        public void doNow();
    }
}

