/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.coverage.export;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.pitest.coverage.BlockCoverage;
import org.pitest.coverage.CoverageExporter;
import org.pitest.mutationtest.engine.Location;
import org.pitest.util.ResultOutputStrategy;
import org.pitest.util.StringUtil;
import org.pitest.util.Unchecked;

public class DefaultCoverageExporter
implements CoverageExporter {
    private final ResultOutputStrategy outputStrategy;

    public DefaultCoverageExporter(ResultOutputStrategy outputStrategy) {
        this.outputStrategy = outputStrategy;
    }

    @Override
    public void recordCoverage(Collection<BlockCoverage> coverage) {
        Writer out = this.outputStrategy.createWriterForFile("linecoverage.xml");
        this.writeHeader(out);
        for (BlockCoverage each : coverage) {
            this.writeLineCoverage(each, out);
        }
        this.writeFooterAndClose(out);
    }

    private void writeHeader(Writer out) {
        this.write(out, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.write(out, "<coverage>\n");
    }

    private void writeLineCoverage(BlockCoverage each, Writer out) {
        Location l = each.getBlock().getLocation();
        this.write(out, "<block classname='" + l.getClassName().asJavaName() + "' method='" + StringUtil.escapeBasicHtmlChars((String)l.getMethodName().name()) + StringUtil.escapeBasicHtmlChars((String)l.getMethodDesc()) + "' number='" + each.getBlock().getBlock() + "'>");
        this.write(out, "<tests>\n");
        ArrayList ts = new ArrayList(each.getTests());
        Collections.sort(ts);
        for (String test : ts) {
            this.write(out, "<test name='" + test + "'/>\n");
        }
        this.write(out, "</tests>\n");
        this.write(out, "</block>\n");
    }

    private void writeFooterAndClose(Writer out) {
        try {
            this.write(out, "</coverage>\n");
            out.close();
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException((Throwable)e);
        }
    }

    private void write(Writer out, String value) {
        try {
            out.write(value);
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException((Throwable)e);
        }
    }
}

