/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.verify;

import java.util.Collection;
import org.pitest.classinfo.ClassInfo;
import org.pitest.classpath.CodeSource;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.FunctionalList;
import org.pitest.functional.SideEffect1;
import org.pitest.help.Help;
import org.pitest.help.PitHelpError;
import org.pitest.mutationtest.verify.BuildVerifier;

public class DefaultBuildVerifier
implements BuildVerifier {
    @Override
    public void verify(CodeSource code) {
        FunctionalList codeClasses = FCollection.filter((Iterable)code.getCode(), DefaultBuildVerifier.isNotSynthetic());
        if (this.hasMutableCode((Collection<ClassInfo>)codeClasses)) {
            this.checkAtLeastOneClassHasLineNumbers((Collection<ClassInfo>)codeClasses);
            FCollection.forEach((Iterable)codeClasses, this.throwErrorIfHasNoSourceFile());
        }
    }

    private boolean hasMutableCode(Collection<ClassInfo> codeClasses) {
        return !codeClasses.isEmpty() && this.hasAtLeastOneClass(codeClasses);
    }

    private boolean hasAtLeastOneClass(Collection<ClassInfo> codeClasses) {
        return FCollection.contains(codeClasses, DefaultBuildVerifier.aConcreteClass());
    }

    private void checkAtLeastOneClassHasLineNumbers(Collection<ClassInfo> codeClasses) {
        if (!FCollection.contains(codeClasses, DefaultBuildVerifier.aClassWithLineNumbers())) {
            throw new PitHelpError(Help.NO_LINE_NUMBERS, new Object[0]);
        }
    }

    private static F<ClassInfo, Boolean> aConcreteClass() {
        return new F<ClassInfo, Boolean>(){

            public Boolean apply(ClassInfo a) {
                return !a.isInterface();
            }
        };
    }

    private static F<ClassInfo, Boolean> aClassWithLineNumbers() {
        return new F<ClassInfo, Boolean>(){

            public Boolean apply(ClassInfo a) {
                return a.getNumberOfCodeLines() != 0;
            }
        };
    }

    private SideEffect1<ClassInfo> throwErrorIfHasNoSourceFile() {
        return new SideEffect1<ClassInfo>(){

            public void apply(ClassInfo a) {
                if (a.getSourceFileName() == null) {
                    throw new PitHelpError(Help.NO_SOURCE_FILE, new Object[]{a.getName().asJavaName()});
                }
            }
        };
    }

    private static F<ClassInfo, Boolean> isNotSynthetic() {
        return new F<ClassInfo, Boolean>(){

            public Boolean apply(ClassInfo a) {
                return !a.isSynthetic();
            }
        };
    }
}

