/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.classinfo;

import java.lang.annotation.Annotation;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.pitest.classinfo.ClassIdentifier;
import org.pitest.classinfo.ClassInfoBuilder;
import org.pitest.classinfo.ClassName;
import org.pitest.classinfo.ClassPointer;
import org.pitest.classinfo.HierarchicalClassId;
import org.pitest.functional.FCollection;

public class ClassInfo {
    private final ClassIdentifier id;
    private final int access;
    private final Set<Integer> codeLines;
    private final ClassPointer outerClass;
    private final ClassPointer superClass;
    private final Collection<ClassName> annotations;
    private final String sourceFile;
    private final Map<ClassName, Object> classAnnotationValues;

    public ClassInfo(ClassPointer superClass, ClassPointer outerClass, ClassInfoBuilder builder) {
        this.superClass = superClass;
        this.outerClass = outerClass;
        this.id = builder.id;
        this.access = builder.access;
        this.codeLines = builder.codeLines;
        this.annotations = FCollection.map(builder.annotations, ClassName.stringToClassName());
        this.sourceFile = builder.sourceFile;
        this.classAnnotationValues = builder.classAnnotationValues;
    }

    public int getNumberOfCodeLines() {
        return this.codeLines.size();
    }

    public boolean isCodeLine(int line) {
        return this.codeLines.contains(line);
    }

    public ClassIdentifier getId() {
        return this.id;
    }

    public ClassName getName() {
        return this.id.getName();
    }

    public boolean isInterface() {
        return (this.access & 0x200) != 0;
    }

    public boolean isAbstract() {
        return (this.access & 0x400) != 0;
    }

    public boolean isSynthetic() {
        return (this.access & 0x1000) != 0;
    }

    public boolean isTopLevelClass() {
        return !this.getOuterClass().isPresent();
    }

    public Optional<ClassInfo> getOuterClass() {
        return this.outerClass.fetch();
    }

    public Optional<ClassInfo> getSuperClass() {
        return this.getParent();
    }

    public String getSourceFileName() {
        return this.sourceFile;
    }

    public boolean hasAnnotation(Class<? extends Annotation> annotation) {
        return this.hasAnnotation(ClassName.fromClass(annotation));
    }

    public boolean hasAnnotation(ClassName annotation) {
        return this.annotations.contains(annotation);
    }

    public Object getClassAnnotationValue(ClassName annotation) {
        return this.classAnnotationValues.get(annotation);
    }

    public boolean descendsFrom(Class<?> clazz) {
        return this.descendsFrom(ClassName.fromClass(clazz));
    }

    public HierarchicalClassId getHierarchicalId() {
        return new HierarchicalClassId(this.id, this.getDeepHash());
    }

    public BigInteger getDeepHash() {
        Optional<ClassInfo> outer;
        BigInteger hash = this.getHash();
        Optional<ClassInfo> parent = this.getParent();
        if (parent.isPresent()) {
            hash = hash.add(parent.get().getHash());
        }
        if ((outer = this.getOuterClass()).isPresent()) {
            hash = hash.add(outer.get().getHash());
        }
        return hash;
    }

    public BigInteger getHash() {
        return BigInteger.valueOf(this.id.getHash());
    }

    private Optional<ClassInfo> getParent() {
        if (this.superClass == null) {
            return Optional.empty();
        }
        return this.superClass.fetch();
    }

    private boolean descendsFrom(ClassName clazz) {
        if (!this.getSuperClass().isPresent()) {
            return false;
        }
        if (this.getSuperClass().get().getName().equals(clazz)) {
            return true;
        }
        return this.getSuperClass().get().descendsFrom(clazz);
    }

    public static Predicate<ClassInfo> matchIfAbstract() {
        return a -> a.isAbstract();
    }

    public String toString() {
        return this.id.getName().asJavaName();
    }

    public static Function<ClassInfo, ClassName> toClassName() {
        return a -> a.getName();
    }

    public static Function<ClassInfo, HierarchicalClassId> toFullClassId() {
        return a -> a.getHierarchicalId();
    }
}

