/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.functional.prelude;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.pitest.functional.SideEffect1;
import org.pitest.functional.predicate.And;
import org.pitest.functional.predicate.Or;

public abstract class Prelude {
    @SafeVarargs
    public static final <A> And<A> and(Predicate<A> ... ps) {
        return new And<A>(Arrays.asList(ps));
    }

    public static final <A> And<A> and(Iterable<? extends Predicate<A>> ps) {
        return new And(ps);
    }

    public static final <A> Predicate<A> not(Predicate<A> p) {
        return p.negate();
    }

    @SafeVarargs
    public static final <A> Or<A> or(Predicate<A> ... ps) {
        return new Or<A>(Arrays.asList(ps));
    }

    public static final <A> Or<A> or(Iterable<Predicate<A>> ps) {
        return new Or<A>(ps);
    }

    public static final <A> SideEffect1<A> accumulateTo(Collection<A> collection) {
        return a -> collection.add(a);
    }

    public static <A, B> SideEffect1<A> putToMap(Map<A, B> map, B value) {
        return key -> map.put(key, value);
    }

    public static final <A> Function<A, A> id() {
        return a -> a;
    }

    public static final <A> Function<A, A> id(Class<A> type) {
        return Prelude.id();
    }

    public static final <T> SideEffect1<T> print() {
        return Prelude.printTo(System.out);
    }

    public static final <T> SideEffect1<T> print(Class<T> type) {
        return Prelude.print();
    }

    public static final <T> SideEffect1<T> printTo(Class<T> type, PrintStream stream) {
        return Prelude.printTo(stream);
    }

    public static final <T> SideEffect1<T> printTo(PrintStream stream) {
        return a -> stream.print(a);
    }

    public static <T> SideEffect1<T> printWith(T t) {
        return a -> System.out.print(t + " : " + a);
    }

    public static <T extends Number> Predicate<T> isGreaterThan(T value) {
        return o -> o.longValue() > value.longValue();
    }

    public static <T> Predicate<T> isEqualTo(T value) {
        return o -> o.equals(value);
    }

    public static <T> Predicate<T> isNotNull() {
        return o -> o != null;
    }

    public static <T> Predicate<T> isNull() {
        return o -> o == null;
    }

    public static <T> Function<T, Iterable<T>> asList(Class<T> type) {
        return a -> Collections.singletonList(a);
    }

    public static <T> SideEffect1<T> noSideEffect(Class<T> clazz) {
        return a -> {};
    }
}

