/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.engine.gregor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.pitest.bytecode.FrameOptions;
import org.pitest.bytecode.NullVisitor;
import org.pitest.classinfo.ClassByteArraySource;
import org.pitest.classinfo.ClassName;
import org.pitest.classinfo.ComputeClassWriter;
import org.pitest.functional.FCollection;
import org.pitest.functional.prelude.Prelude;
import org.pitest.mutationtest.engine.Mutant;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.mutationtest.engine.gregor.ClassContext;
import org.pitest.mutationtest.engine.gregor.MethodInfo;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.mutationtest.engine.gregor.MutatingClassVisitor;
import org.pitest.reloc.asm.ClassReader;

public class GregorMutater
implements Mutater {
    private final Map<String, String> computeCache = new HashMap<String, String>();
    private final Predicate<MethodInfo> filter;
    private final ClassByteArraySource byteSource;
    private final Set<MethodMutatorFactory> mutators = new HashSet<MethodMutatorFactory>();

    public GregorMutater(ClassByteArraySource byteSource, Predicate<MethodInfo> filter, Collection<MethodMutatorFactory> mutators) {
        this.filter = filter;
        this.mutators.addAll(mutators);
        this.byteSource = byteSource;
    }

    @Override
    public List<MutationDetails> findMutations(ClassName classToMutate) {
        ClassContext context = new ClassContext();
        context.setTargetMutation(Optional.empty());
        Optional<byte[]> bytes = this.byteSource.getBytes(classToMutate.asInternalName());
        return bytes.map(this.findMutations(context)).orElse(Collections.emptyList());
    }

    private Function<byte[], List<MutationDetails>> findMutations(ClassContext context) {
        return bytes -> this.findMutationsForBytes(context, (byte[])bytes);
    }

    private List<MutationDetails> findMutationsForBytes(ClassContext context, byte[] classToMutate) {
        ClassReader first = new ClassReader(classToMutate);
        NullVisitor nv = new NullVisitor();
        MutatingClassVisitor mca = new MutatingClassVisitor(nv, context, this.filterMethods(), this.mutators);
        first.accept(mca, 8);
        return new ArrayList<MutationDetails>(context.getCollectedMutations());
    }

    @Override
    public Mutant getMutation(MutationIdentifier id) {
        ClassContext context = new ClassContext();
        context.setTargetMutation(Optional.ofNullable(id));
        Optional<byte[]> bytes = this.byteSource.getBytes(id.getClassName().asJavaName());
        ClassReader reader = new ClassReader(bytes.get());
        ComputeClassWriter w = new ComputeClassWriter(this.byteSource, this.computeCache, FrameOptions.pickFlags(bytes.get()));
        MutatingClassVisitor mca = new MutatingClassVisitor(w, context, this.filterMethods(), FCollection.filter(this.mutators, GregorMutater.isMutatorFor(id)));
        reader.accept(mca, 8);
        List<MutationDetails> details = context.getMutationDetails(context.getTargetMutation().get());
        return new Mutant(details.get(0), w.toByteArray());
    }

    private static Predicate<MethodMutatorFactory> isMutatorFor(MutationIdentifier id) {
        return a -> id.getMutator().equals(a.getGloballyUniqueId());
    }

    private Predicate<MethodInfo> filterMethods() {
        return Prelude.and(this.filter, GregorMutater.filterSyntheticMethods(), GregorMutater.isGeneratedEnumMethod().negate(), GregorMutater.isGroovyClass().negate());
    }

    private static Predicate<MethodInfo> isGroovyClass() {
        return a -> a.isInGroovyClass();
    }

    private static Predicate<MethodInfo> filterSyntheticMethods() {
        return a -> !a.isSynthetic() || a.getName().startsWith("lambda$");
    }

    private static Predicate<MethodInfo> isGeneratedEnumMethod() {
        return a -> a.isGeneratedEnumMethod();
    }
}

