/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.engine.gregor.mutators.rv;

import org.pitest.mutationtest.engine.gregor.MethodInfo;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.mutationtest.engine.gregor.MutationContext;
import org.pitest.mutationtest.engine.gregor.mutators.rv.AbstractCRCRVisitor;
import org.pitest.reloc.asm.MethodVisitor;

public enum CRCR4Mutator implements MethodMutatorFactory
{
    CRCR_4_MUTATOR;


    @Override
    public MethodVisitor create(MutationContext context, MethodInfo methodInfo, MethodVisitor methodVisitor) {
        return new CRCRVisitor1(context, methodVisitor);
    }

    @Override
    public String getGloballyUniqueId() {
        return this.getClass().getName();
    }

    @Override
    public String getName() {
        return this.name();
    }

    private final class CRCRVisitor1
    extends AbstractCRCRVisitor {
        CRCRVisitor1(MutationContext context, MethodVisitor delegateVisitor) {
            super(context, delegateVisitor, CRCR4Mutator.this);
        }

        @Override
        void mutate(Double constant) {
            Double replacement = -constant.doubleValue();
            if (!constant.equals(0.0) && this.shouldMutate(constant, replacement)) {
                this.translateToByteCode(replacement);
            } else {
                this.translateToByteCode(constant);
            }
        }

        @Override
        void mutate(Float constant) {
            Float replacement = Float.valueOf(-constant.floatValue());
            if (!constant.equals(Float.valueOf(0.0f)) && this.shouldMutate(constant, replacement)) {
                this.translateToByteCode(replacement);
            } else {
                this.translateToByteCode(constant);
            }
        }

        @Override
        void mutate(Integer constant) {
            Integer replacement = constant == Integer.MIN_VALUE ? Integer.MAX_VALUE : -constant.intValue();
            if (!constant.equals(0) && this.shouldMutate(constant, replacement)) {
                this.translateToByteCode(replacement);
            } else {
                this.translateToByteCode(constant);
            }
        }

        @Override
        void mutate(Long constant) {
            Long replacement = constant == Long.MIN_VALUE ? Long.MAX_VALUE : -constant.longValue();
            if (!constant.equals(0L) && this.shouldMutate(constant, replacement)) {
                this.translateToByteCode(replacement);
            } else {
                this.translateToByteCode(constant);
            }
        }
    }
}

