/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.io;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jbehave.core.Embeddable;
import org.jbehave.core.io.AbstractStoryPathResolver;
import org.jbehave.core.io.StoryPathResolver;

public class UnderscoredCamelCaseResolver
extends AbstractStoryPathResolver {
    public static final String NUMBERS_AS_LOWER_CASE_LETTERS_PATTERN = "([A-Z].*?)([A-Z]|\\z)";
    public static final String NUMBERS_AS_UPPER_CASE_LETTERS_PATTERN = "([A-Z0-9].*?)([A-Z0-9]|\\z)";
    private static final String UNDERSCORE = "_";
    private final String resolutionPattern;
    private final Locale locale;
    private String wordToRemove = "";

    public UnderscoredCamelCaseResolver() {
        this(".story");
    }

    public UnderscoredCamelCaseResolver(String extension) {
        this(extension, NUMBERS_AS_LOWER_CASE_LETTERS_PATTERN);
    }

    public UnderscoredCamelCaseResolver(String extension, String resolutionPattern) {
        this(extension, resolutionPattern, Locale.getDefault());
    }

    public UnderscoredCamelCaseResolver(String extension, String resolutionPattern, Locale locale) {
        super(extension);
        this.resolutionPattern = resolutionPattern;
        this.locale = locale;
    }

    @Override
    protected String resolveName(Class<? extends Embeddable> embeddableClass) {
        String simpleName = embeddableClass.getSimpleName();
        simpleName = simpleName.replace(this.wordToRemove, "");
        Matcher matcher = Pattern.compile(this.resolutionPattern).matcher(simpleName);
        int startAt = 0;
        StringBuilder builder = new StringBuilder();
        while (matcher.find(startAt)) {
            builder.append(matcher.group(1).toLowerCase(this.locale));
            builder.append(UNDERSCORE);
            startAt = matcher.start(2);
        }
        return builder.substring(0, builder.length() - 1);
    }

    public StoryPathResolver removeFromClassName(String wordToRemove) {
        this.wordToRemove = wordToRemove;
        return this;
    }
}

