/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.embedder;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jbehave.core.embedder.EmbedderControls;
import org.jbehave.core.steps.ParameterConverters;

public class PropertyBasedEmbedderControls
extends EmbedderControls {
    public static final String BATCH = "BATCH";
    public static final String IGNORE_FAILURE_IN_VIEW = "IGNORE_FAILURE_IN_VIEW";
    public static final String IGNORE_FAILURE_IN_STORIES = "IGNORE_FAILURE_IN_STORIES";
    public static final String GENERATE_VIEW_AFTER_STORIES = "GENERATE_VIEW_AFTER_STORIES";
    public static final String SKIP = "SKIP";
    public static final String VERBOSE_FAILURES = "VERBOSE_FAILURES";
    public static final String VERBOSE_FILTERING = "VERBOSE_FILTERING";
    public static final String STORY_TIMEOUTS = "STORY_TIMEOUTS";
    public static final String STORY_TIMEOUT_IN_SECS = "STORY_TIMEOUT_IN_SECS";
    public static final String STORY_TIMEOUT_IN_SECS_BY_PATH = "STORY_TIMEOUT_IN_SECS_BY_PATH";
    public static final String FAIL_ON_STORY_TIMEOUT = "FAIL_ON_STORY_TIMEOUT";
    public static final String THREADS = "THREADS";
    private ParameterConverters converters = new ParameterConverters();

    @Override
    public boolean batch() {
        return this.propertyAs(BATCH, Boolean.class, super.batch());
    }

    @Override
    public boolean ignoreFailureInView() {
        return this.propertyAs(IGNORE_FAILURE_IN_VIEW, Boolean.class, super.ignoreFailureInView());
    }

    @Override
    public boolean ignoreFailureInStories() {
        return this.propertyAs(IGNORE_FAILURE_IN_STORIES, Boolean.class, super.ignoreFailureInStories());
    }

    @Override
    public boolean generateViewAfterStories() {
        return this.propertyAs(GENERATE_VIEW_AFTER_STORIES, Boolean.class, super.generateViewAfterStories());
    }

    @Override
    public boolean skip() {
        return this.propertyAs(SKIP, Boolean.class, super.skip());
    }

    @Override
    public boolean verboseFailures() {
        return this.propertyAs(VERBOSE_FAILURES, Boolean.class, super.verboseFailures());
    }

    @Override
    public boolean verboseFiltering() {
        return this.propertyAs(VERBOSE_FILTERING, Boolean.class, super.verboseFiltering());
    }

    @Override
    public String storyTimeouts() {
        return this.propertyAs(STORY_TIMEOUTS, String.class, super.storyTimeouts());
    }

    @Override
    public long storyTimeoutInSecs() {
        return this.propertyAs(STORY_TIMEOUT_IN_SECS, Long.class, super.storyTimeoutInSecs());
    }

    @Override
    public String storyTimeoutInSecsByPath() {
        return this.propertyAs(STORY_TIMEOUT_IN_SECS_BY_PATH, String.class, super.storyTimeoutInSecsByPath());
    }

    @Override
    public boolean failOnStoryTimeout() {
        return this.propertyAs(FAIL_ON_STORY_TIMEOUT, Boolean.class, super.failOnStoryTimeout());
    }

    @Override
    public int threads() {
        return this.propertyAs(THREADS, Integer.class, super.threads());
    }

    private <T> T propertyAs(String name, Class<T> type, T defaultValue) {
        String property = System.getProperty(name);
        if (property == null) {
            return defaultValue;
        }
        return (T)this.converters.convert(property, type);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("batch", this.batch()).append("skip", this.skip()).append("generateViewAfterStories", this.generateViewAfterStories()).append("ignoreFailureInStories", this.ignoreFailureInStories()).append("ignoreFailureInView", this.ignoreFailureInView()).append("verboseFailures", this.verboseFailures()).append("verboseFiltering", this.verboseFiltering()).append("storyTimeoutInSecs", this.storyTimeoutInSecs()).append("storyTimeoutInSecsByPath", (Object)this.storyTimeoutInSecsByPath()).append("threads", this.threads()).toString();
    }
}

