/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.model;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jbehave.core.annotations.Parameter;
import org.jbehave.core.model.TableTransformers;
import org.jbehave.core.model.TableUtils;
import org.jbehave.core.steps.ChainedRow;
import org.jbehave.core.steps.ConvertedParameters;
import org.jbehave.core.steps.ParameterConverters;
import org.jbehave.core.steps.Parameters;
import org.jbehave.core.steps.Row;

public class ExamplesTable {
    private static final Map<String, String> EMPTY_MAP = Collections.emptyMap();
    private static final String EMPTY_VALUE = "";
    public static final ExamplesTable EMPTY = new ExamplesTable("");
    private static final String ROW_SEPARATOR = "\r?\n";
    private static final String NEW_LINE = "\n";
    private static final String HEADER_SEPARATOR = "|";
    private static final String VALUE_SEPARATOR = "|";
    private static final String IGNORABLE_SEPARATOR = "|--";
    private final String tableAsString;
    private final String headerSeparator;
    private final String valueSeparator;
    private final String ignorableSeparator;
    private final ParameterConverters parameterConverters;
    private final TableTransformers tableTransformers;
    private final Row defaults;
    private final List<String> headers = new ArrayList<String>();
    private final List<Map<String, String>> data = new ArrayList<Map<String, String>>();
    private final Properties properties = new Properties();
    private String propertiesAsString = "";
    private Map<String, String> namedParameters = new HashMap<String, String>();
    private boolean trim = true;

    public ExamplesTable(String tableAsString) {
        this(tableAsString, "|", "|");
    }

    public ExamplesTable(String tableAsString, String headerSeparator, String valueSeparator) {
        this(tableAsString, headerSeparator, valueSeparator, IGNORABLE_SEPARATOR, new ParameterConverters());
    }

    public ExamplesTable(String tableAsString, String headerSeparator, String valueSeparator, String ignorableSeparator, ParameterConverters parameterConverters) {
        this(tableAsString, headerSeparator, valueSeparator, ignorableSeparator, parameterConverters, new TableTransformers());
    }

    public ExamplesTable(String tableAsString, String headerSeparator, String valueSeparator, String ignorableSeparator, ParameterConverters parameterConverters, TableTransformers tableTransformers) {
        this.tableAsString = tableAsString;
        this.headerSeparator = headerSeparator;
        this.valueSeparator = valueSeparator;
        this.ignorableSeparator = ignorableSeparator;
        this.parameterConverters = parameterConverters;
        this.tableTransformers = tableTransformers;
        this.defaults = new ConvertedParameters(EMPTY_MAP, parameterConverters);
        this.parse();
    }

    private void parse() {
        String tableWithoutProperties = this.stripProperties(this.tableAsString.trim());
        this.parseProperties(this.propertiesAsString);
        this.trim = Boolean.parseBoolean(this.properties.getProperty("trim", "true"));
        this.parseTable(tableWithoutProperties);
    }

    private ExamplesTable(ExamplesTable other, Row defaults) {
        this.data.addAll(other.data);
        this.tableAsString = other.tableAsString;
        this.headerSeparator = other.headerSeparator;
        this.valueSeparator = other.valueSeparator;
        this.ignorableSeparator = other.ignorableSeparator;
        this.parameterConverters = other.parameterConverters;
        this.tableTransformers = other.tableTransformers;
        this.headers.addAll(other.headers);
        this.properties.putAll((Map<?, ?>)other.properties);
        this.defaults = defaults;
    }

    private String stripProperties(String tableAsString) {
        Pattern pattern = Pattern.compile("\\{(.*?)\\}\\s*(.*)", 32);
        Matcher matcher = pattern.matcher(tableAsString);
        if (matcher.matches()) {
            this.propertiesAsString = matcher.group(1);
            return matcher.group(2);
        }
        return tableAsString;
    }

    private void parseProperties(String propertiesAsString) {
        this.properties.clear();
        this.properties.setProperty("ignorableSeparator", this.ignorableSeparator);
        this.properties.setProperty("headerSeparator", this.headerSeparator);
        this.properties.setProperty("valueSeparator", this.valueSeparator);
        try {
            this.properties.load(new ByteArrayInputStream(propertiesAsString.replace(",", NEW_LINE).getBytes()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void parseTable(String tableAsString) {
        this.headers.clear();
        this.data.clear();
        String transformer = this.properties.getProperty("transformer");
        if (transformer != null) {
            tableAsString = this.tableTransformers.transform(transformer, tableAsString, this.properties);
        }
        this.parseByRows(this.headers, this.data, tableAsString);
    }

    private void parseByRows(List<String> headers, List<Map<String, String>> data, String tableAsString) {
        String[] rows = tableAsString.split(ROW_SEPARATOR);
        for (int row = 0; row < rows.length; ++row) {
            String rowAsString = rows[row];
            if (rowAsString.startsWith(this.properties.getProperty("ignorableSeparator")) || rowAsString.length() == 0) continue;
            if (headers.isEmpty()) {
                headers.addAll(TableUtils.parseRow(rowAsString, this.properties.getProperty("headerSeparator"), this.properties.getProperty("commentSeparator"), this.trim));
                continue;
            }
            List<String> columns = TableUtils.parseRow(rowAsString, this.properties.getProperty("valueSeparator"), this.properties.getProperty("commentSeparator"), this.trim);
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            for (int column = 0; column < columns.size(); ++column) {
                if (column >= headers.size()) continue;
                map.put(headers.get(column), columns.get(column));
            }
            data.add(map);
        }
    }

    public ExamplesTable withDefaults(Parameters defaults) {
        return new ExamplesTable(this, new ChainedRow(defaults, this.defaults));
    }

    public ExamplesTable withNamedParameters(Map<String, String> namedParameters) {
        this.namedParameters = namedParameters;
        return this;
    }

    public ExamplesTable withRowValues(int row, Map<String, String> values) {
        this.getRow(row).putAll(values);
        for (String header : values.keySet()) {
            if (this.headers.contains(header)) continue;
            this.headers.add(header);
        }
        return this;
    }

    public ExamplesTable withRows(List<Map<String, String>> values) {
        this.data.clear();
        this.data.addAll(values);
        this.headers.clear();
        this.headers.addAll(values.get(0).keySet());
        return this;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public Map<String, String> getRow(int row) {
        if (row > this.data.size() - 1) {
            throw new RowNotFound(row);
        }
        Map<String, String> values = this.data.get(row);
        if (this.headers.size() != values.keySet().size()) {
            for (String header : this.headers) {
                if (values.containsKey(header)) continue;
                values.put(header, EMPTY_VALUE);
            }
        }
        return values;
    }

    public Parameters getRowAsParameters(int row) {
        return this.getRowAsParameters(row, false);
    }

    public Parameters getRowAsParameters(int row, boolean replaceNamedParameters) {
        Map<String, String> rowValues = this.getRow(row);
        return this.createParameters(replaceNamedParameters ? this.replaceNamedParameters(rowValues) : rowValues);
    }

    private Map<String, String> replaceNamedParameters(Map<String, String> row) {
        HashMap<String, String> replaced = new HashMap<String, String>();
        for (String key : row.keySet()) {
            String replacedValue = row.get(key);
            for (String namedKey : this.namedParameters.keySet()) {
                String namedValue = this.namedParameters.get(namedKey);
                replacedValue = replacedValue.replaceAll(namedKey, Matcher.quoteReplacement(namedValue));
            }
            replaced.put(key, replacedValue);
        }
        return replaced;
    }

    public int getRowCount() {
        return this.data.size();
    }

    public boolean metaByRow() {
        return Boolean.parseBoolean(this.properties.getProperty("metaByRow", "false"));
    }

    public List<Map<String, String>> getRows() {
        ArrayList<Map<String, String>> rows = new ArrayList<Map<String, String>>();
        for (int row = 0; row < this.getRowCount(); ++row) {
            rows.add(this.getRow(row));
        }
        return rows;
    }

    public List<Parameters> getRowsAsParameters() {
        return this.getRowsAsParameters(false);
    }

    public List<Parameters> getRowsAsParameters(boolean replaceNamedParameters) {
        ArrayList<Parameters> rows = new ArrayList<Parameters>();
        for (int row = 0; row < this.getRowCount(); ++row) {
            rows.add(this.getRowAsParameters(row, replaceNamedParameters));
        }
        return rows;
    }

    public <T> List<T> getRowsAs(Class<T> type) {
        return this.getRowsAs(type, new HashMap<String, String>());
    }

    public <T> List<T> getRowsAs(Class<T> type, Map<String, String> fieldNameMapping) {
        ArrayList<T> rows = new ArrayList<T>();
        for (Parameters parameters : this.getRowsAsParameters()) {
            rows.add(this.mapToType(parameters, type, fieldNameMapping));
        }
        return rows;
    }

    private <T> T mapToType(Parameters parameters, Class<T> type, Map<String, String> fieldNameMapping) {
        try {
            T instance = type.newInstance();
            Map<String, String> values = parameters.values();
            for (String name : values.keySet()) {
                Field field = this.findField(type, name, fieldNameMapping);
                Type fieldType = field.getGenericType();
                Object value = parameters.valueAs(name, fieldType);
                field.setAccessible(true);
                field.set(instance, value);
            }
            return instance;
        }
        catch (Exception e) {
            throw new ParametersNotMappableToType(parameters, type, e);
        }
    }

    private <T> Field findField(Class<T> type, String name, Map<String, String> fieldNameMapping) throws NoSuchFieldException {
        String fieldName = fieldNameMapping.get(name);
        if (fieldName == null) {
            fieldName = name;
        }
        for (Field field : type.getDeclaredFields()) {
            Parameter parameter;
            if (!field.isAnnotationPresent(Parameter.class) || !fieldName.equals((parameter = field.getAnnotation(Parameter.class)).name())) continue;
            return field;
        }
        return type.getDeclaredField(fieldName);
    }

    private Parameters createParameters(Map<String, String> values) {
        return new ConvertedParameters(new ChainedRow(new ConvertedParameters(values, this.parameterConverters), this.defaults), this.parameterConverters);
    }

    public String getHeaderSeparator() {
        return this.headerSeparator;
    }

    public String getValueSeparator() {
        return this.valueSeparator;
    }

    public String asString() {
        if (this.data.isEmpty()) {
            return EMPTY_VALUE;
        }
        return this.format();
    }

    public void outputTo(PrintStream output) {
        output.print(this.asString());
    }

    private String format() {
        StringBuffer sb = new StringBuffer();
        if (!this.propertiesAsString.isEmpty()) {
            sb.append("{").append(this.propertiesAsString).append("}").append(NEW_LINE);
        }
        for (String string : this.headers) {
            sb.append(this.headerSeparator).append(string);
        }
        sb.append(this.headerSeparator).append(NEW_LINE);
        for (Map map : this.getRows()) {
            for (String header : this.headers) {
                sb.append(this.valueSeparator);
                sb.append((String)map.get(header));
            }
            sb.append(this.valueSeparator).append(NEW_LINE);
        }
        return sb.toString();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static class ParametersNotMappableToType
    extends RuntimeException {
        public ParametersNotMappableToType(Parameters parameters, Class<?> type, Exception e) {
            super(parameters.values() + " not mappable to type " + type, e);
        }
    }

    public static class RowNotFound
    extends RuntimeException {
        public RowNotFound(int row) {
            super(Integer.toString(row));
        }
    }
}

