/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.model;

import org.apache.commons.lang3.StringUtils;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.i18n.LocalizedKeywords;
import org.jbehave.core.io.LoadFromClasspath;
import org.jbehave.core.io.ResourceLoader;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.TableTransformers;
import org.jbehave.core.steps.ParameterConverters;

public class ExamplesTableFactory {
    private Keywords keywords;
    private final ResourceLoader resourceLoader;
    private final ParameterConverters parameterConverters;
    private final TableTransformers tableTransformers;

    public ExamplesTableFactory() {
        this(new LocalizedKeywords());
    }

    public ExamplesTableFactory(Keywords keywords) {
        this(keywords, new LoadFromClasspath(), new ParameterConverters(), new TableTransformers());
    }

    public ExamplesTableFactory(ResourceLoader resourceLoader) {
        this(new LocalizedKeywords(), resourceLoader, new ParameterConverters(), new TableTransformers());
    }

    public ExamplesTableFactory(ParameterConverters parameterConverters) {
        this(new LocalizedKeywords(), new LoadFromClasspath(), parameterConverters, new TableTransformers());
    }

    public ExamplesTableFactory(TableTransformers tableTransformers) {
        this(new LocalizedKeywords(), new LoadFromClasspath(), new ParameterConverters(), tableTransformers);
    }

    public ExamplesTableFactory(Keywords keywords, ResourceLoader resourceLoader, ParameterConverters parameterConverters) {
        this(keywords, resourceLoader, parameterConverters, new TableTransformers());
    }

    public ExamplesTableFactory(Keywords keywords, ResourceLoader resourceLoader, ParameterConverters parameterConverters, TableTransformers tableTranformers) {
        this.keywords = keywords;
        this.resourceLoader = resourceLoader;
        this.parameterConverters = parameterConverters;
        this.tableTransformers = tableTranformers;
    }

    public ExamplesTableFactory(Configuration configuration) {
        this.keywords = configuration.keywords();
        this.resourceLoader = configuration.storyLoader();
        this.parameterConverters = configuration.parameterConverters();
        this.tableTransformers = new TableTransformers();
    }

    public ExamplesTable createExamplesTable(String input) {
        String tableAsString = StringUtils.isBlank((CharSequence)input) || this.isTable(input) ? input : this.resourceLoader.loadResourceAsText(input);
        return new ExamplesTable(tableAsString, this.keywords.examplesTableHeaderSeparator(), this.keywords.examplesTableValueSeparator(), this.keywords.examplesTableIgnorableSeparator(), this.parameterConverters, this.tableTransformers);
    }

    protected boolean isTable(String input) {
        return input.contains(this.keywords.examplesTableHeaderSeparator());
    }

    public void useKeywords(Keywords keywords) {
        this.keywords = keywords;
    }

    public Keywords keywords() {
        return this.keywords;
    }
}

