/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.reporters;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jbehave.core.failures.RestartingStoryFailure;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.GivenStories;
import org.jbehave.core.model.Lifecycle;
import org.jbehave.core.model.Meta;
import org.jbehave.core.model.Narrative;
import org.jbehave.core.model.OutcomesTable;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.Story;
import org.jbehave.core.model.StoryDuration;
import org.jbehave.core.reporters.StoryReporter;

public class PostStoryStatisticsCollector
implements StoryReporter {
    private final OutputStream output;
    private final Map<String, Integer> data = new HashMap<String, Integer>();
    private final List<String> events = Arrays.asList("notAllowed", "pending", "scenariosNotAllowed", "givenStoryScenariosNotAllowed", "steps", "stepsSuccessful", "stepsIgnorable", "comments", "stepsPending", "stepsNotPerformed", "stepsFailed", "currentScenarioSteps", "currentScenarioStepsPending", "scenarios", "scenariosSuccessful", "scenariosPending", "scenariosFailed", "givenStories", "givenStoryScenarios", "givenStoryScenariosSuccessful", "givenStoryScenariosPending", "givenStoryScenariosFailed", "examples");
    private Throwable cause;
    private OutcomesTable outcomesFailed;
    private int givenStories;
    private boolean currentScenarioNotAllowed;

    public PostStoryStatisticsCollector(OutputStream output) {
        this.output = output;
    }

    @Override
    public void beforeStep(String step) {
    }

    @Override
    public void successful(String step) {
        this.add("steps");
        this.add("stepsSuccessful");
        this.add("currentScenarioSteps");
    }

    @Override
    public void ignorable(String step) {
        this.add("steps");
        this.add("stepsIgnorable");
        this.add("currentScenarioSteps");
    }

    @Override
    public void comment(String step) {
        this.add("steps");
        this.add("comments");
        this.add("currentScenarioSteps");
    }

    @Override
    public void pending(String step) {
        this.add("steps");
        this.add("stepsPending");
        this.add("currentScenarioSteps");
        this.add("currentScenarioStepsPending");
    }

    @Override
    public void notPerformed(String step) {
        this.add("steps");
        this.add("stepsNotPerformed");
        this.add("currentScenarioSteps");
    }

    @Override
    public void failed(String step, Throwable cause) {
        this.cause = cause;
        if (cause != null && !(cause.getCause() instanceof RestartingStoryFailure)) {
            this.add("steps");
            this.add("stepsFailed");
            this.add("currentScenarioSteps");
        }
    }

    @Override
    public void failedOutcomes(String step, OutcomesTable table) {
        this.outcomesFailed = table;
        this.add("steps");
        this.add("stepsFailed");
        this.add("currentScenarioSteps");
    }

    @Override
    public void beforeStory(Story story, boolean givenStory) {
        if (givenStory) {
            ++this.givenStories;
        }
        if (!givenStory) {
            this.resetData();
        }
    }

    @Override
    public void narrative(Narrative narrative) {
    }

    @Override
    public void lifecyle(Lifecycle lifecycle) {
    }

    @Override
    public void storyNotAllowed(Story story, String filter) {
        this.resetData();
        this.add("notAllowed");
        this.writeData();
    }

    @Override
    public void storyCancelled(Story story, StoryDuration storyDuration) {
        this.add("cancelled");
    }

    @Override
    public void afterStory(boolean givenStory) {
        boolean write = false;
        if (givenStory) {
            --this.givenStories;
            if (this.has("stepsFailed")) {
                this.add("scenariosFailed");
                write = true;
            }
        } else {
            if (this.has("scenariosPending") || this.has("givenStoryScenariosPending")) {
                this.add("pending");
            }
            write = true;
        }
        if (write) {
            this.writeData();
        }
    }

    @Override
    public void givenStories(GivenStories givenStories) {
        this.add("givenStories");
    }

    @Override
    public void givenStories(List<String> storyPaths) {
        this.add("givenStories");
    }

    @Override
    public void beforeScenario(String title) {
        this.cause = null;
        this.outcomesFailed = null;
        this.currentScenarioNotAllowed = false;
        this.reset("currentScenarioSteps");
        this.reset("currentScenarioStepsPending");
    }

    @Override
    public void scenarioNotAllowed(Scenario scenario, String filter) {
        if (this.givenStories > 0) {
            this.add("givenStoryScenariosNotAllowed");
        } else {
            this.add("scenariosNotAllowed");
            this.currentScenarioNotAllowed = true;
        }
    }

    @Override
    public void scenarioMeta(Meta meta) {
    }

    @Override
    public void afterScenario() {
        if (this.givenStories > 0) {
            this.countScenarios("givenStoryScenarios");
        } else {
            this.countScenarios("scenarios");
        }
        if (this.has("currentScenarioStepsPending") || !this.has("currentScenarioSteps") && !this.currentScenarioNotAllowed) {
            if (this.givenStories > 0) {
                this.add("givenStoryScenariosPending");
            } else {
                this.add("scenariosPending");
            }
        }
    }

    private void countScenarios(String namespace) {
        this.add(namespace);
        if (!this.currentScenarioNotAllowed) {
            if (this.cause != null || this.outcomesFailed != null) {
                this.add(namespace + "Failed");
            } else {
                this.add(namespace + "Successful");
            }
        }
    }

    @Override
    public void beforeExamples(List<String> steps, ExamplesTable table) {
    }

    @Override
    public void example(Map<String, String> tableRow) {
        this.add("examples");
    }

    @Override
    public void afterExamples() {
    }

    @Override
    public void dryRun() {
    }

    @Override
    public void pendingMethods(List<String> methods) {
    }

    @Override
    public void restarted(String step, Throwable cause) {
    }

    @Override
    public void restartedStory(Story story, Throwable cause) {
        this.resetData();
    }

    private void add(String event) {
        Integer count = this.data.get(event);
        if (count == null) {
            count = 0;
        }
        Integer n = count;
        Integer n2 = count = Integer.valueOf(count + 1);
        this.data.put(event, count);
    }

    private boolean has(String event) {
        Integer count = this.data.get(event);
        if (count == null) {
            count = 0;
        }
        return count > 0;
    }

    private void writeData() {
        Properties p = new Properties();
        for (String event : this.data.keySet()) {
            if (event.startsWith("current")) continue;
            p.setProperty(event, this.data.get(event).toString());
        }
        try {
            p.store(this.output, this.getClass().getName());
            this.output.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void resetData() {
        this.data.clear();
        for (String event : this.events) {
            this.reset(event);
        }
    }

    private void reset(String event) {
        this.data.put(event, 0);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append((Object)this.output).append(this.data).toString();
    }
}

