/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import java.io.PrintStream;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.Arrays;
import org.jbehave.core.model.StepPattern;
import org.jbehave.core.reporters.Format;
import org.jbehave.core.steps.StepMonitor;
import org.jbehave.core.steps.StepType;

public class PrintStreamStepMonitor
implements StepMonitor {
    private static final String CONVERTED_VALUE_OF_TYPE = "Converted value ''{0}'' of type ''{1}'' to ''{2}'' with converter ''{3}''";
    private static final String STEP_MATCHES_TYPE = "Step ''{0}'' (with previous step ''{1}'') ''{2}'' type ''{3}'' for method ''{4}'' with annotations ''{5}'' in steps instance ''{6}''";
    private static final String STEP_MATCHES_PATTERN = "Step ''{0}'' {1} pattern ''{2}'' for method ''{3}'' with annotations ''{4}'' in steps instance ''{5}''";
    private static final String PERFORMING = "Performing step ''{0}'' {1}";
    private static final String DRY_RUN = "(DRY RUN)";
    private static final String MATCHES = "matches";
    private static final String DOES_NOT_MATCH = "does not match";
    private static final String USING_NAME_FOR_PARAMETER = "Using {0} name ''{1}'' for parameter position {2}";
    private static final String ANNOTATED = "annotated";
    private static final String PARAMETER = "parameter";
    private static final String TABLE_ANNOTATED = "table annotated";
    private static final String TABLE_PARAMETER = "table parameter";
    private static final String USING_NATURAL_ORDER_FOR_PARAMETER = "Using natural order for parameter position {0}";
    private static final String FOUND_PARAMETER = "Found parameter ''{0}'' for position {1}";
    private static final String STEPS_CONTEXT_PARAMETER = "Found parameter ''{0}'' from Steps Context";
    private final PrintStream output;

    public PrintStreamStepMonitor() {
        this(System.out);
    }

    public PrintStreamStepMonitor(PrintStream output) {
        this.output = output;
    }

    @Override
    public void stepMatchesType(String step, String previous, boolean matches, StepType stepType, Method method, Object stepsInstance) {
        String message = MessageFormat.format(STEP_MATCHES_TYPE, new Object[]{step, previous, matches ? MATCHES : DOES_NOT_MATCH, stepType, method, Arrays.asList(method.getAnnotations()), stepsInstance});
        this.print(this.output, message);
    }

    @Override
    public void stepMatchesPattern(String step, boolean matches, StepPattern stepPattern, Method method, Object stepsInstance) {
        String message = MessageFormat.format(STEP_MATCHES_PATTERN, step, matches ? MATCHES : DOES_NOT_MATCH, stepPattern, method, Arrays.asList(method.getAnnotations()), stepsInstance);
        this.print(this.output, message);
    }

    @Override
    public void convertedValueOfType(String value, Type type, Object converted, Class<?> converterClass) {
        this.print(this.output, MessageFormat.format(CONVERTED_VALUE_OF_TYPE, value, type, converted, converterClass));
    }

    @Override
    public void performing(String step, boolean dryRun) {
        this.print(this.output, MessageFormat.format(PERFORMING, step, dryRun ? DRY_RUN : ""));
    }

    @Override
    public void usingAnnotatedNameForParameter(String name, int position) {
        this.print(this.output, MessageFormat.format(USING_NAME_FOR_PARAMETER, ANNOTATED, name, position));
    }

    @Override
    public void usingParameterNameForParameter(String name, int position) {
        this.print(this.output, MessageFormat.format(USING_NAME_FOR_PARAMETER, PARAMETER, name, position));
    }

    @Override
    public void usingTableAnnotatedNameForParameter(String name, int position) {
        this.print(this.output, MessageFormat.format(USING_NAME_FOR_PARAMETER, TABLE_ANNOTATED, name, position));
    }

    @Override
    public void usingTableParameterNameForParameter(String name, int position) {
        this.print(this.output, MessageFormat.format(USING_NAME_FOR_PARAMETER, TABLE_PARAMETER, name, position));
    }

    @Override
    public void usingNaturalOrderForParameter(int position) {
        this.print(this.output, MessageFormat.format(USING_NATURAL_ORDER_FOR_PARAMETER, position));
    }

    @Override
    public void foundParameter(String parameter, int position) {
        this.print(this.output, MessageFormat.format(FOUND_PARAMETER, parameter, position));
    }

    @Override
    public void usingStepsContextParameter(String parameter) {
        this.print(this.output, MessageFormat.format(STEPS_CONTEXT_PARAMETER, parameter));
    }

    protected void print(PrintStream output, String message) {
        Format.println(output, message);
    }
}

