/*
 * Decompiled with CFR 0.152.
 */
package jsint;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import jsint.E;
import jsint.Evaluator;
import jsint.Import;
import jsint.Invoke;
import jsint.LexicalEnvironment;
import jsint.Pair;
import jsint.Reflector;
import jsint.StaticReflector;
import jsint.U;

public class JavaField
extends Reflector {
    static final Hashtable fieldTable = new Hashtable(20);
    static final Hashtable fieldTablePriv = new Hashtable(20);
    String className;
    transient Field f;
    boolean isStatic = false;
    transient Hashtable classTable;

    static Hashtable fieldTable0(boolean isPrivileged) {
        if (isPrivileged) {
            return fieldTablePriv;
        }
        return fieldTable;
    }

    public static Field getField(Class c, String name, boolean isPrivileged) {
        try {
            return isPrivileged ? JavaField.getDeclaredField(c, name) : c.getField(name);
        }
        catch (NoSuchFieldException e2) {
            return (Field)E.error("no such field: " + c + "." + name);
        }
        catch (Exception e) {
            return (Field)E.error("error accessing field: " + c + "." + name + " is " + e);
        }
    }

    private static Hashtable getFieldClassTable(String name, boolean isPrivileged) {
        Hashtable ft = JavaField.fieldTable0(isPrivileged);
        Hashtable table = (Hashtable)ft.get(name);
        if (table == null) {
            table = new Hashtable(3);
            ft.put(name, table);
        }
        return table;
    }

    private static Field getDeclaredField(Class c, String name) throws NoSuchFieldException {
        try {
            Field[] fs = (Field[])Invoke.makeAccessible(c.getDeclaredFields());
            for (int i = 0; i < fs.length; ++i) {
                if (!fs[i].getName().equals(name)) continue;
                return fs[i];
            }
            Class s = c.getSuperclass();
            if (s != null) {
                return JavaField.getDeclaredField(s, name);
            }
            return (Field)E.error("\n\nERROR: no field: \"" + name + "\" for class \"" + c + "\"");
        }
        catch (Exception e) {
            return c.getField(name);
        }
    }

    public JavaField(String name, Class c) {
        this(name, c, false);
    }

    public JavaField(String name, Class c, boolean isPrivileged) {
        this.name = name;
        this.isPrivileged = isPrivileged;
        if (c != null) {
            this.className = c.getName();
        }
        this.reset();
    }

    protected synchronized void reset() {
        Class c;
        Class clazz = c = this.className == null ? null : Import.classNamed(this.className);
        if (c != null) {
            this.f = JavaField.getField(c, this.name, this.isPrivileged);
            this.isStatic = Modifier.isStatic(this.f.getModifiers());
            this.minArgs = this.isStatic ? 0 : 1;
            this.maxArgs = Modifier.isFinal(this.f.getModifiers()) ? this.minArgs : this.minArgs + 1;
        } else {
            this.classTable = JavaField.getFieldClassTable(this.name, this.isPrivileged);
            this.minArgs = 1;
            this.maxArgs = 2;
        }
    }

    public Object[] makeArgArray(Object[] code, Evaluator eval, LexicalEnvironment lexenv) {
        int L = code.length - 1;
        if (L == 0 && this.isStatic) {
            return StaticReflector.args0;
        }
        if (L == 1) {
            return new Object[]{eval.execute(code[1], lexenv)};
        }
        if (L == 2 && !this.isStatic) {
            return new Object[]{eval.execute(code[1], lexenv), eval.execute(code[2], lexenv)};
        }
        return (Object[])E.error("Wrong number of arguments to field " + this + " " + U.stringify(code));
    }

    public Object[] makeArgArray(Pair args) {
        int L = args.length();
        if (L == 0 && this.isStatic) {
            return StaticReflector.args0;
        }
        if (L == 1) {
            return new Object[]{args.first()};
        }
        if (L == 2 && !this.isStatic) {
            return new Object[]{args.first(), args.second()};
        }
        return (Object[])E.error("Wrong number of arguments to field " + this + " " + U.stringify(args));
    }

    public Object apply(Object[] args) {
        int L = args.length;
        if (this.isStatic) {
            if (L == 1) {
                return this.setStaticFieldValue(this.f, args[0]);
            }
            return this.getStaticFieldValue(this.f);
        }
        if (L == 1) {
            return this.getFieldValue(args[0], this.getTargetField(args[0]));
        }
        return this.setFieldValue(args[0], this.getTargetField(args[0]), args[1]);
    }

    public Field getTargetField(Object target) {
        if (this.f != null) {
            return this.f;
        }
        Class<?> c = target.getClass();
        Field it = (Field)this.classTable.get(c);
        if (it != null) {
            return it;
        }
        it = JavaField.getField(c, this.name, this.isPrivileged);
        if (it == null) {
            return (Field)E.error(U.stringify(target) + " does not have a field " + this.name);
        }
        this.classTable.put(c, it);
        return it;
    }

    public Object getFieldValue(Object target, Field f) {
        try {
            return f.get(target);
        }
        catch (IllegalAccessException e) {
            return E.error("Illegal Access to field: " + f + " in " + U.stringify(target));
        }
    }

    public Object setFieldValue(Object target, Field f, Object value) {
        try {
            Object old = f.get(target);
            f.set(target, value);
            return old;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public Object getStaticFieldValue(Field f) {
        try {
            return f.get(null);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public Object setStaticFieldValue(Field f, Object value) {
        try {
            Object old = f.get(null);
            f.set(null, value);
            return old;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }
}

