/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.classpath;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.zip.ZipException;
import org.pitest.classpath.ArchiveClassPathRoot;
import org.pitest.classpath.ClassPathRoot;
import org.pitest.classpath.CompoundClassPathRoot;
import org.pitest.classpath.DirectoryClassPathRoot;
import org.pitest.functional.FCollection;
import org.pitest.util.Log;
import org.pitest.util.ManifestUtils;
import org.pitest.util.PitError;
import org.pitest.util.StreamUtil;

public class ClassPath {
    private static final Logger LOG = Log.getLogger();
    private final CompoundClassPathRoot root;

    public ClassPath() {
        this(ClassPath.getClassPathElementsAsFiles());
    }

    public ClassPath(ClassPathRoot ... roots) {
        this(Arrays.asList(roots));
    }

    public ClassPath(Collection<File> files) {
        this(ClassPath.createRoots(FCollection.filter(files, ClassPath.exists())));
    }

    ClassPath(List<ClassPathRoot> roots) {
        this.root = new CompoundClassPathRoot(roots);
    }

    public Collection<String> classNames() {
        return this.root.classNames();
    }

    private static List<ClassPathRoot> createRoots(Collection<File> files) {
        File lastFile = null;
        try {
            ArrayList<ClassPathRoot> rs = new ArrayList<ClassPathRoot>();
            Iterator<File> iterator = files.iterator();
            while (iterator.hasNext()) {
                File f;
                lastFile = f = iterator.next();
                if (f.isDirectory()) {
                    rs.add(new DirectoryClassPathRoot(f));
                    continue;
                }
                ClassPath.handleArchive(rs, f);
            }
            return rs;
        }
        catch (IOException ex) {
            throw new PitError("Error handling file " + lastFile, ex);
        }
    }

    private static void handleArchive(List<ClassPathRoot> rs, File f) throws IOException {
        try {
            if (!f.canRead()) {
                throw new IOException("Can't read the file " + f);
            }
            rs.add(new ArchiveClassPathRoot(f));
        }
        catch (ZipException ex) {
            LOG.warning("Can't open the archive " + f);
        }
    }

    public byte[] getClassData(String classname) throws IOException {
        try (InputStream is = this.root.getData(classname);){
            if (is != null) {
                byte[] byArray = StreamUtil.streamToByteArray(is);
                return byArray;
            }
            byte[] byArray = null;
            return byArray;
        }
    }

    public URL findResource(String name) {
        try {
            return this.root.getResource(name);
        }
        catch (IOException exception) {
            return null;
        }
    }

    public static Collection<String> getClassPathElementsAsPaths() {
        LinkedHashSet<String> filesAsString = new LinkedHashSet<String>();
        FCollection.mapTo(ClassPath.getClassPathElementsAsFiles(), file -> file.getPath(), filesAsString);
        return filesAsString;
    }

    public static Collection<File> getClassPathElementsAsFiles() {
        LinkedHashSet<File> us = new LinkedHashSet<File>();
        FCollection.mapTo(ClassPath.getClassPathElementsAsAre(), ClassPath.stringToCanonicalFile(), us);
        ClassPath.addEntriesFromClasspathManifest(us);
        return us;
    }

    private static void addEntriesFromClasspathManifest(Set<File> elements) {
        Optional<File> maybeJar = elements.stream().filter(f -> f.getName().startsWith("classpath") && f.getName().endsWith(".jar")).findFirst();
        maybeJar.ifPresent(file -> elements.addAll(ManifestUtils.readClasspathManifest(file)));
    }

    public Collection<String> findClasses(Predicate<String> nameFilter) {
        return FCollection.filter(this.classNames(), nameFilter);
    }

    public String getLocalClassPath() {
        return this.root.cacheLocation().get();
    }

    public ClassPath getComponent(Predicate<ClassPathRoot> predicate) {
        return new ClassPath(FCollection.filter(this.root, predicate).toArray(new ClassPathRoot[0]));
    }

    private static Predicate<File> exists() {
        return a -> a.exists() && a.canRead();
    }

    private static Function<String, File> stringToCanonicalFile() {
        return fileAsString -> {
            try {
                return new File((String)fileAsString).getCanonicalFile();
            }
            catch (IOException ex) {
                throw new PitError("Error transforming classpath element " + fileAsString, ex);
            }
        };
    }

    private static List<String> getClassPathElementsAsAre() {
        String classPath = System.getProperty("java.class.path");
        String separator = File.pathSeparator;
        if (classPath != null) {
            return Arrays.asList(classPath.split(separator));
        }
        return new ArrayList<String>();
    }
}

