/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.coverage;

import java.io.Serializable;
import java.util.Optional;
import java.util.function.Function;
import org.pitest.classinfo.ClassName;

public final class TestInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String definingClass;
    private final int time;
    private final int blocks;
    private final ClassName testee;

    public TestInfo(String definingClass, String name, int time, Optional<ClassName> testee, int blocksCovered) {
        this.definingClass = TestInfo.internIfNotNull(definingClass);
        this.name = name;
        this.time = time;
        this.testee = testee.orElse(null);
        this.blocks = blocksCovered;
    }

    public String getName() {
        return this.name;
    }

    public int getTime() {
        return this.time;
    }

    public int getNumberOfBlocksCovered() {
        return this.blocks;
    }

    public String toString() {
        return this.name;
    }

    public static Function<TestInfo, String> toName() {
        return a -> a.getName();
    }

    public static Function<TestInfo, ClassName> toDefiningClassName() {
        return a -> ClassName.fromString(a.definingClass);
    }

    public boolean directlyHits(ClassName targetClass) {
        return this.testee != null && this.testee.equals(targetClass);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.definingClass == null ? 0 : this.definingClass.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TestInfo other = (TestInfo)obj;
        if (this.definingClass == null ? other.definingClass != null : !this.definingClass.equals(other.definingClass)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    private static String internIfNotNull(String string) {
        if (string == null) {
            return null;
        }
        return string.intern();
    }
}

