/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.junit;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import junit.runner.Version;
import org.pitest.extension.common.CompoundTestSuiteFinder;
import org.pitest.help.Help;
import org.pitest.help.PitHelpError;
import org.pitest.junit.CompoundTestUnitFinder;
import org.pitest.junit.JUnit4SuiteFinder;
import org.pitest.junit.JUnitCustomRunnerTestUnitFinder;
import org.pitest.junit.JUnitVersion;
import org.pitest.junit.ParameterisedJUnitTestFinder;
import org.pitest.junit.RunnerSuiteFinder;
import org.pitest.testapi.Configuration;
import org.pitest.testapi.TestGroupConfig;
import org.pitest.testapi.TestSuiteFinder;
import org.pitest.testapi.TestUnitFinder;
import org.pitest.util.Preconditions;

public class JUnitCompatibleConfiguration
implements Configuration {
    private final TestGroupConfig config;
    private final Collection<String> excludedRunners;
    private final Collection<String> includedTestMethods;
    private static final JUnitVersion MIN_JUNIT_VERSION = JUnitVersion.parse("4.6");

    public JUnitCompatibleConfiguration(TestGroupConfig config, Collection<String> excludedRunners, Collection<String> includedTestMethods) {
        Preconditions.checkNotNull(config);
        this.config = config;
        this.excludedRunners = excludedRunners;
        this.includedTestMethods = includedTestMethods;
    }

    @Override
    public TestUnitFinder testUnitFinder() {
        return new CompoundTestUnitFinder(Arrays.asList(new JUnitCustomRunnerTestUnitFinder(this.config, this.excludedRunners, this.includedTestMethods), new ParameterisedJUnitTestFinder()));
    }

    @Override
    public TestSuiteFinder testSuiteFinder() {
        return new CompoundTestSuiteFinder(Arrays.asList(new JUnit4SuiteFinder(), new RunnerSuiteFinder()));
    }

    @Override
    public Optional<PitHelpError> verifyEnvironment() {
        try {
            String version = Version.id();
            if (this.isInvalidVersion(version)) {
                return Optional.ofNullable(new PitHelpError(Help.WRONG_JUNIT_VERSION, version));
            }
        }
        catch (NoClassDefFoundError er) {
            return Optional.ofNullable(new PitHelpError(Help.NO_JUNIT, new Object[0]));
        }
        return Optional.empty();
    }

    boolean isInvalidVersion(String version) {
        try {
            JUnitVersion jUnitVersion = JUnitVersion.parse(version);
            return jUnitVersion.isLessThan(MIN_JUNIT_VERSION);
        }
        catch (IllegalArgumentException e) {
            return true;
        }
    }
}

