/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.engine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.pitest.classinfo.ClassName;
import org.pitest.coverage.ClassLine;
import org.pitest.coverage.TestInfo;
import org.pitest.mutationtest.engine.MethodName;
import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.mutationtest.engine.PoisonStatus;
import org.pitest.util.Preconditions;
import org.pitest.util.StringUtil;

public final class MutationDetails
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final MutationIdentifier id;
    private final String filename;
    private final int block;
    private final int lineNumber;
    private final String description;
    private final ArrayList<TestInfo> testsInOrder = new ArrayList();
    private final boolean isInFinallyBlock;
    private final PoisonStatus poison;

    public MutationDetails(MutationIdentifier id, String filename, String description, int lineNumber, int block) {
        this(id, filename, description, lineNumber, block, false, PoisonStatus.NORMAL);
    }

    public MutationDetails(MutationIdentifier id, String filename, String description, int lineNumber, int block, boolean isInFinallyBlock, PoisonStatus poison) {
        this.id = id;
        this.description = Preconditions.checkNotNull(description);
        this.filename = Preconditions.checkNotNull(filename);
        this.lineNumber = lineNumber;
        this.block = block;
        this.isInFinallyBlock = isInFinallyBlock;
        this.poison = poison;
    }

    public String toString() {
        return "MutationDetails [id=" + this.id + ", filename=" + this.filename + ", block=" + this.block + ", lineNumber=" + this.lineNumber + ", description=" + this.description + ", testsInOrder=" + this.testsInOrder + ", isInFinallyBlock=" + this.isInFinallyBlock + ", poison=" + (Object)((Object)this.poison) + "]";
    }

    public MutationDetails withDescription(String desc) {
        return new MutationDetails(this.id, this.filename, desc, this.lineNumber, this.block, this.isInFinallyBlock, this.poison);
    }

    public MutationDetails withPoisonStatus(PoisonStatus poisonStatus) {
        return new MutationDetails(this.id, this.filename, this.description, this.lineNumber, this.block, this.isInFinallyBlock, poisonStatus);
    }

    public String getDescription() {
        return this.description;
    }

    @Deprecated
    public String getHtmlSafeDescription() {
        return StringUtil.escapeBasicHtmlChars(this.description);
    }

    @Deprecated
    public String getLocation() {
        return this.id.getLocation().describe();
    }

    public ClassName getClassName() {
        return this.id.getClassName();
    }

    public MethodName getMethod() {
        return this.id.getLocation().getMethodName();
    }

    public String getFilename() {
        return this.filename;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public ClassLine getClassLine() {
        return new ClassLine(this.id.getClassName(), this.lineNumber);
    }

    public MutationIdentifier getId() {
        return this.id;
    }

    public List<TestInfo> getTestsInOrder() {
        return this.testsInOrder;
    }

    public void addTestsInOrder(Collection<TestInfo> testNames) {
        this.testsInOrder.addAll(testNames);
        this.testsInOrder.trimToSize();
    }

    public boolean mayPoisonJVM() {
        return this.poison.mayPoison();
    }

    public boolean isInStaticInitializer() {
        return this.poison == PoisonStatus.IS_STATIC_INITIALIZER_CODE;
    }

    public int getBlock() {
        return this.block;
    }

    public Boolean matchesId(MutationIdentifier id) {
        return this.id.matches(id);
    }

    public String getMutator() {
        return this.id.getMutator();
    }

    public int getFirstIndex() {
        return this.id.getFirstIndex();
    }

    public int getInstructionIndex() {
        return this.getFirstIndex() - 1;
    }

    public boolean isInFinallyBlock() {
        return this.isInFinallyBlock;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MutationDetails other = (MutationDetails)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

