/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.engine.gregor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.pitest.functional.FCollection;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.mutationtest.engine.gregor.ClassInfo;
import org.pitest.mutationtest.engine.gregor.blocks.BlockCounter;
import org.pitest.mutationtest.engine.gregor.blocks.ConcreteBlockCounter;

class ClassContext
implements BlockCounter {
    private ClassInfo classInfo;
    private String sourceFile;
    private Optional<MutationIdentifier> target = Optional.empty();
    private final List<MutationDetails> mutations = new ArrayList<MutationDetails>();
    private final ConcreteBlockCounter blockCounter = new ConcreteBlockCounter();

    ClassContext() {
    }

    public Optional<MutationIdentifier> getTargetMutation() {
        return this.target;
    }

    public ClassInfo getClassInfo() {
        return this.classInfo;
    }

    public String getJavaClassName() {
        return this.classInfo.getName().replace("/", ".");
    }

    public String getFileName() {
        return this.sourceFile;
    }

    public void setTargetMutation(Optional<MutationIdentifier> target) {
        this.target = target;
    }

    public List<MutationDetails> getMutationDetails(MutationIdentifier id) {
        return FCollection.filter(this.mutations, ClassContext.hasId(id));
    }

    private static Predicate<MutationDetails> hasId(MutationIdentifier id) {
        return a -> a.matchesId(id);
    }

    public void registerClass(ClassInfo classInfo) {
        this.classInfo = classInfo;
    }

    public void registerSourceFile(String source) {
        this.sourceFile = source;
    }

    public boolean shouldMutate(MutationIdentifier newId) {
        return this.getTargetMutation().filter(ClassContext.idMatches(newId)).isPresent();
    }

    private static Predicate<MutationIdentifier> idMatches(MutationIdentifier newId) {
        return a -> a.matches(newId);
    }

    public Collection<MutationDetails> getCollectedMutations() {
        return this.mutations;
    }

    public void addMutation(MutationDetails details) {
        this.mutations.add(details);
    }

    @Override
    public void registerNewBlock() {
        this.blockCounter.registerNewBlock();
    }

    @Override
    public void registerFinallyBlockStart() {
        this.blockCounter.registerFinallyBlockStart();
    }

    @Override
    public void registerFinallyBlockEnd() {
        this.blockCounter.registerFinallyBlockEnd();
    }

    public int getCurrentBlock() {
        return this.blockCounter.getCurrentBlock();
    }

    public boolean isWithinFinallyBlock() {
        return this.blockCounter.isWithinFinallyBlock();
    }
}

