/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.engine.gregor.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Function;
import org.pitest.functional.FCollection;
import org.pitest.functional.prelude.Prelude;
import org.pitest.help.Help;
import org.pitest.help.PitHelpError;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.mutationtest.engine.gregor.mutators.ArgumentPropagationMutator;
import org.pitest.mutationtest.engine.gregor.mutators.BooleanFalseReturnValsMutator;
import org.pitest.mutationtest.engine.gregor.mutators.BooleanTrueReturnValsMutator;
import org.pitest.mutationtest.engine.gregor.mutators.ConditionalsBoundaryMutator;
import org.pitest.mutationtest.engine.gregor.mutators.ConstructorCallMutator;
import org.pitest.mutationtest.engine.gregor.mutators.EmptyObjectReturnValsMutator;
import org.pitest.mutationtest.engine.gregor.mutators.IncrementsMutator;
import org.pitest.mutationtest.engine.gregor.mutators.InlineConstantMutator;
import org.pitest.mutationtest.engine.gregor.mutators.InvertNegsMutator;
import org.pitest.mutationtest.engine.gregor.mutators.MathMutator;
import org.pitest.mutationtest.engine.gregor.mutators.NegateConditionalsMutator;
import org.pitest.mutationtest.engine.gregor.mutators.NonVoidMethodCallMutator;
import org.pitest.mutationtest.engine.gregor.mutators.NullReturnValsMutator;
import org.pitest.mutationtest.engine.gregor.mutators.PrimitiveReturnsMutator;
import org.pitest.mutationtest.engine.gregor.mutators.RemoveConditionalMutator;
import org.pitest.mutationtest.engine.gregor.mutators.ReturnValsMutator;
import org.pitest.mutationtest.engine.gregor.mutators.VoidMethodCallMutator;
import org.pitest.mutationtest.engine.gregor.mutators.experimental.BigIntegerMutator;
import org.pitest.mutationtest.engine.gregor.mutators.experimental.MemberVariableMutator;
import org.pitest.mutationtest.engine.gregor.mutators.experimental.NakedReceiverMutator;
import org.pitest.mutationtest.engine.gregor.mutators.experimental.RemoveIncrementsMutator;
import org.pitest.mutationtest.engine.gregor.mutators.experimental.RemoveSwitchMutator;
import org.pitest.mutationtest.engine.gregor.mutators.experimental.SwitchMutator;
import org.pitest.mutationtest.engine.gregor.mutators.rv.ABSMutator;
import org.pitest.mutationtest.engine.gregor.mutators.rv.AOD1Mutator;
import org.pitest.mutationtest.engine.gregor.mutators.rv.AOD2Mutator;
import org.pitest.mutationtest.engine.gregor.mutators.rv.AOR1Mutator;
import org.pitest.mutationtest.engine.gregor.mutators.rv.AOR2Mutator;
import org.pitest.mutationtest.engine.gregor.mutators.rv.AOR3Mutator;
import org.pitest.mutationtest.engine.gregor.mutators.rv.AOR4Mutator;
import org.pitest.mutationtest.engine.gregor.mutators.rv.CRCR1Mutator;
import org.pitest.mutationtest.engine.gregor.mutators.rv.CRCR2Mutator;
import org.pitest.mutationtest.engine.gregor.mutators.rv.CRCR3Mutator;
import org.pitest.mutationtest.engine.gregor.mutators.rv.CRCR4Mutator;
import org.pitest.mutationtest.engine.gregor.mutators.rv.CRCR5Mutator;
import org.pitest.mutationtest.engine.gregor.mutators.rv.CRCR6Mutator;
import org.pitest.mutationtest.engine.gregor.mutators.rv.OBBN1Mutator;
import org.pitest.mutationtest.engine.gregor.mutators.rv.OBBN2Mutator;
import org.pitest.mutationtest.engine.gregor.mutators.rv.OBBN3Mutator;
import org.pitest.mutationtest.engine.gregor.mutators.rv.ROR1Mutator;
import org.pitest.mutationtest.engine.gregor.mutators.rv.ROR2Mutator;
import org.pitest.mutationtest.engine.gregor.mutators.rv.ROR3Mutator;
import org.pitest.mutationtest.engine.gregor.mutators.rv.ROR4Mutator;
import org.pitest.mutationtest.engine.gregor.mutators.rv.ROR5Mutator;
import org.pitest.mutationtest.engine.gregor.mutators.rv.UOI1Mutator;
import org.pitest.mutationtest.engine.gregor.mutators.rv.UOI2Mutator;
import org.pitest.mutationtest.engine.gregor.mutators.rv.UOI3Mutator;
import org.pitest.mutationtest.engine.gregor.mutators.rv.UOI4Mutator;

public final class Mutator {
    private static final Map<String, Iterable<MethodMutatorFactory>> MUTATORS = new LinkedHashMap<String, Iterable<MethodMutatorFactory>>();

    private static void experimentalMutators() {
        Mutator.add("EXPERIMENTAL_MEMBER_VARIABLE", new MemberVariableMutator());
        Mutator.add("EXPERIMENTAL_SWITCH", new SwitchMutator());
        Mutator.add("EXPERIMENTAL_ARGUMENT_PROPAGATION", ArgumentPropagationMutator.ARGUMENT_PROPAGATION_MUTATOR);
        Mutator.add("EXPERIMENTAL_NAKED_RECEIVER", NakedReceiverMutator.NAKED_RECEIVER);
        Mutator.add("EXPERIMENTAL_BIG_INTEGER", BigIntegerMutator.INSTANCE);
    }

    private static void researchMutators() {
        Mutator.add("AOR_1", AOR1Mutator.AOR_1_MUTATOR);
        Mutator.add("AOR_2", AOR2Mutator.AOR_2_MUTATOR);
        Mutator.add("AOR_3", AOR3Mutator.AOR_3_MUTATOR);
        Mutator.add("AOR_4", AOR4Mutator.AOR_4_MUTATOR);
        Mutator.add("ABS", ABSMutator.ABS_MUTATOR);
        Mutator.add("AOD1", AOD1Mutator.AOD_1_MUTATOR);
        Mutator.add("AOD1", AOD2Mutator.AOD_2_MUTATOR);
        Mutator.add("CRCR1", CRCR1Mutator.CRCR_1_MUTATOR);
        Mutator.add("CRCR2", CRCR2Mutator.CRCR_2_MUTATOR);
        Mutator.add("CRCR3", CRCR3Mutator.CRCR_3_MUTATOR);
        Mutator.add("CRCR4", CRCR4Mutator.CRCR_4_MUTATOR);
        Mutator.add("CRCR5", CRCR5Mutator.CRCR_5_MUTATOR);
        Mutator.add("CRCR6", CRCR6Mutator.CRCR_6_MUTATOR);
        Mutator.add("OBBN1", OBBN1Mutator.OBBN_1_MUTATOR);
        Mutator.add("OBBN2", OBBN2Mutator.OBBN_2_MUTATOR);
        Mutator.add("OBBN3", OBBN3Mutator.OBBN_3_MUTATOR);
        Mutator.add("ROR1", ROR1Mutator.ROR_1_MUTATOR);
        Mutator.add("ROR2", ROR2Mutator.ROR_2_MUTATOR);
        Mutator.add("ROR3", ROR3Mutator.ROR_3_MUTATOR);
        Mutator.add("ROR4", ROR4Mutator.ROR_4_MUTATOR);
        Mutator.add("ROR5", ROR5Mutator.ROR_5_MUTATOR);
        Mutator.add("UOI1", UOI1Mutator.UOI_1_MUTATOR);
        Mutator.add("UOI2", UOI2Mutator.UOI_2_MUTATOR);
        Mutator.add("UOI3", UOI3Mutator.UOI_3_MUTATOR);
        Mutator.add("UOI4", UOI4Mutator.UOI_4_MUTATOR);
    }

    public static Collection<MethodMutatorFactory> all() {
        return Mutator.fromStrings(MUTATORS.keySet());
    }

    private static Collection<MethodMutatorFactory> stronger() {
        return Mutator.combine(Mutator.defaults(), Mutator.group(new RemoveConditionalMutator(RemoveConditionalMutator.Choice.EQUAL, false), new SwitchMutator()));
    }

    private static Collection<MethodMutatorFactory> combine(Collection<MethodMutatorFactory> a, Collection<MethodMutatorFactory> b) {
        ArrayList<MethodMutatorFactory> l = new ArrayList<MethodMutatorFactory>(a);
        l.addAll(b);
        return l;
    }

    public static Collection<MethodMutatorFactory> defaults() {
        return Mutator.group(InvertNegsMutator.INVERT_NEGS_MUTATOR, ReturnValsMutator.RETURN_VALS_MUTATOR, MathMutator.MATH_MUTATOR, VoidMethodCallMutator.VOID_METHOD_CALL_MUTATOR, NegateConditionalsMutator.NEGATE_CONDITIONALS_MUTATOR, ConditionalsBoundaryMutator.CONDITIONALS_BOUNDARY_MUTATOR, IncrementsMutator.INCREMENTS_MUTATOR);
    }

    public static Collection<MethodMutatorFactory> newDefaults() {
        return Mutator.combine(Mutator.group(InvertNegsMutator.INVERT_NEGS_MUTATOR, MathMutator.MATH_MUTATOR, VoidMethodCallMutator.VOID_METHOD_CALL_MUTATOR, NegateConditionalsMutator.NEGATE_CONDITIONALS_MUTATOR, ConditionalsBoundaryMutator.CONDITIONALS_BOUNDARY_MUTATOR, IncrementsMutator.INCREMENTS_MUTATOR), Mutator.betterReturns());
    }

    public static Collection<MethodMutatorFactory> betterReturns() {
        return Mutator.group(BooleanTrueReturnValsMutator.BOOLEAN_TRUE_RETURN, BooleanFalseReturnValsMutator.BOOLEAN_FALSE_RETURN, PrimitiveReturnsMutator.PRIMITIVE_RETURN_VALS_MUTATOR, EmptyObjectReturnValsMutator.EMPTY_RETURN_VALUES, NullReturnValsMutator.NULL_RETURN_VALUES);
    }

    public static Collection<MethodMutatorFactory> aor() {
        return Mutator.group(AOR1Mutator.AOR_1_MUTATOR, AOR2Mutator.AOR_2_MUTATOR, AOR3Mutator.AOR_3_MUTATOR, AOR4Mutator.AOR_4_MUTATOR);
    }

    public static Collection<MethodMutatorFactory> aod() {
        return Mutator.group(AOD1Mutator.AOD_1_MUTATOR, AOD2Mutator.AOD_2_MUTATOR);
    }

    public static Collection<MethodMutatorFactory> crcr() {
        return Mutator.group(CRCR1Mutator.CRCR_1_MUTATOR, CRCR2Mutator.CRCR_2_MUTATOR, CRCR3Mutator.CRCR_3_MUTATOR, CRCR4Mutator.CRCR_4_MUTATOR, CRCR5Mutator.CRCR_5_MUTATOR, CRCR6Mutator.CRCR_6_MUTATOR);
    }

    public static Collection<MethodMutatorFactory> obbn() {
        return Mutator.group(OBBN1Mutator.OBBN_1_MUTATOR, OBBN2Mutator.OBBN_2_MUTATOR, OBBN3Mutator.OBBN_3_MUTATOR);
    }

    public static Collection<MethodMutatorFactory> ror() {
        return Mutator.group(ROR1Mutator.ROR_1_MUTATOR, ROR2Mutator.ROR_2_MUTATOR, ROR3Mutator.ROR_3_MUTATOR, ROR4Mutator.ROR_4_MUTATOR, ROR5Mutator.ROR_5_MUTATOR);
    }

    public static Collection<MethodMutatorFactory> uoi() {
        return Mutator.group(UOI1Mutator.UOI_1_MUTATOR, UOI2Mutator.UOI_2_MUTATOR, UOI3Mutator.UOI_3_MUTATOR, UOI4Mutator.UOI_4_MUTATOR);
    }

    private static Collection<MethodMutatorFactory> group(MethodMutatorFactory ... ms) {
        return Arrays.asList(ms);
    }

    public static Collection<MethodMutatorFactory> byName(String name) {
        return FCollection.map(MUTATORS.get(name), Prelude.id(MethodMutatorFactory.class));
    }

    private static void add(String key, MethodMutatorFactory value) {
        MUTATORS.put(key, Collections.singleton(value));
    }

    private static void addGroup(String key, Iterable<MethodMutatorFactory> value) {
        MUTATORS.put(key, value);
    }

    public static Collection<MethodMutatorFactory> fromStrings(Collection<String> names) {
        TreeSet<MethodMutatorFactory> unique = new TreeSet<MethodMutatorFactory>(Mutator.compareId());
        FCollection.flatMapTo(names, Mutator.fromString(), unique);
        return unique;
    }

    private static Comparator<? super MethodMutatorFactory> compareId() {
        return (o1, o2) -> o1.getGloballyUniqueId().compareTo(o2.getGloballyUniqueId());
    }

    private static Function<String, Iterable<MethodMutatorFactory>> fromString() {
        return a -> {
            Iterable<MethodMutatorFactory> i = MUTATORS.get(a);
            if (i == null) {
                throw new PitHelpError(Help.UNKNOWN_MUTATOR, a);
            }
            return i;
        };
    }

    static {
        Mutator.add("INVERT_NEGS", InvertNegsMutator.INVERT_NEGS_MUTATOR);
        Mutator.add("RETURN_VALS", ReturnValsMutator.RETURN_VALS_MUTATOR);
        Mutator.add("INLINE_CONSTS", new InlineConstantMutator());
        Mutator.add("MATH", MathMutator.MATH_MUTATOR);
        Mutator.add("VOID_METHOD_CALLS", VoidMethodCallMutator.VOID_METHOD_CALL_MUTATOR);
        Mutator.add("NEGATE_CONDITIONALS", NegateConditionalsMutator.NEGATE_CONDITIONALS_MUTATOR);
        Mutator.add("CONDITIONALS_BOUNDARY", ConditionalsBoundaryMutator.CONDITIONALS_BOUNDARY_MUTATOR);
        Mutator.add("INCREMENTS", IncrementsMutator.INCREMENTS_MUTATOR);
        Mutator.add("REMOVE_INCREMENTS", RemoveIncrementsMutator.REMOVE_INCREMENTS_MUTATOR);
        Mutator.add("NON_VOID_METHOD_CALLS", NonVoidMethodCallMutator.NON_VOID_METHOD_CALL_MUTATOR);
        Mutator.add("CONSTRUCTOR_CALLS", ConstructorCallMutator.CONSTRUCTOR_CALL_MUTATOR);
        Mutator.add("REMOVE_CONDITIONALS_EQ_IF", new RemoveConditionalMutator(RemoveConditionalMutator.Choice.EQUAL, true));
        Mutator.add("REMOVE_CONDITIONALS_EQ_ELSE", new RemoveConditionalMutator(RemoveConditionalMutator.Choice.EQUAL, false));
        Mutator.add("REMOVE_CONDITIONALS_ORD_IF", new RemoveConditionalMutator(RemoveConditionalMutator.Choice.ORDER, true));
        Mutator.add("REMOVE_CONDITIONALS_ORD_ELSE", new RemoveConditionalMutator(RemoveConditionalMutator.Choice.ORDER, false));
        Mutator.addGroup("REMOVE_CONDITIONALS", RemoveConditionalMutator.makeMutators());
        Mutator.add("TRUE_RETURNS", BooleanTrueReturnValsMutator.BOOLEAN_TRUE_RETURN);
        Mutator.add("FALSE_RETURNS", BooleanFalseReturnValsMutator.BOOLEAN_FALSE_RETURN);
        Mutator.add("PRIMITIVE_RETURNS", PrimitiveReturnsMutator.PRIMITIVE_RETURN_VALS_MUTATOR);
        Mutator.add("EMPTY_RETURNS", EmptyObjectReturnValsMutator.EMPTY_RETURN_VALUES);
        Mutator.add("NULL_RETURNS", NullReturnValsMutator.NULL_RETURN_VALUES);
        Mutator.addGroup("RETURNS", Mutator.betterReturns());
        Mutator.experimentalMutators();
        Mutator.researchMutators();
        Mutator.addGroup("REMOVE_SWITCH", RemoveSwitchMutator.makeMutators());
        Mutator.addGroup("DEFAULTS", Mutator.defaults());
        Mutator.addGroup("STRONGER", Mutator.stronger());
        Mutator.addGroup("ALL", Mutator.all());
        Mutator.addGroup("NEW_DEFAULTS", Mutator.newDefaults());
        Mutator.addGroup("AOR", Mutator.aor());
        Mutator.addGroup("AOD", Mutator.aod());
        Mutator.addGroup("CRCR", Mutator.crcr());
        Mutator.addGroup("OBBN", Mutator.obbn());
        Mutator.addGroup("ROR", Mutator.ror());
        Mutator.addGroup("UOI", Mutator.uoi());
    }
}

