/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.engine.gregor.mutators.rv;

import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.mutationtest.engine.gregor.MutationContext;
import org.pitest.reloc.asm.MethodVisitor;

class UOI4MethodVisitor
extends MethodVisitor {
    private final MethodMutatorFactory factory;
    private final MutationContext context;

    UOI4MethodVisitor(MethodMutatorFactory factory, MutationContext context, MethodVisitor delegateMethodVisitor) {
        super(458752, delegateMethodVisitor);
        this.factory = factory;
        this.context = context;
    }

    private boolean shouldMutate(String description) {
        if (this.context.getClassInfo().isEnum()) {
            return false;
        }
        MutationIdentifier newId = this.context.registerMutation(this.factory, description);
        return this.context.shouldMutate(newId);
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        switch (opcode) {
            case 21: {
                if (this.shouldMutate("Decremented (--a) integer local variable number " + var)) {
                    this.mv.visitIincInsn(var, -1);
                }
                this.mv.visitVarInsn(opcode, var);
                break;
            }
            case 23: {
                if (this.shouldMutate("Decremented (--a) float local variable number " + var)) {
                    this.mv.visitVarInsn(opcode, var);
                    this.mv.visitInsn(12);
                    this.mv.visitInsn(102);
                    this.mv.visitVarInsn(56, var);
                }
                this.mv.visitVarInsn(opcode, var);
                break;
            }
            case 22: {
                if (this.shouldMutate("Decremented (--a) long local variable number " + var)) {
                    this.mv.visitVarInsn(opcode, var);
                    this.mv.visitInsn(10);
                    this.mv.visitInsn(101);
                    this.mv.visitVarInsn(55, var);
                }
                this.mv.visitVarInsn(opcode, var);
                break;
            }
            case 24: {
                if (this.shouldMutate("Decremented (--a) double local variable number " + var)) {
                    this.mv.visitVarInsn(opcode, var);
                    this.mv.visitInsn(15);
                    this.mv.visitInsn(103);
                    this.mv.visitVarInsn(57, var);
                }
                this.mv.visitVarInsn(opcode, var);
                break;
            }
            default: {
                this.mv.visitVarInsn(opcode, var);
            }
        }
    }

    @Override
    public void visitInsn(int opcode) {
        switch (opcode) {
            case 46: {
                if (this.shouldMutate("Decremented (--a) integer array field")) {
                    this.mv.visitInsn(92);
                    this.mv.visitInsn(opcode);
                    this.mv.visitInsn(4);
                    this.mv.visitInsn(100);
                    this.mv.visitInsn(91);
                    this.mv.visitInsn(79);
                    break;
                }
                this.mv.visitInsn(opcode);
                break;
            }
            case 48: {
                if (this.shouldMutate("Decremented (--a) float array field")) {
                    this.mv.visitInsn(92);
                    this.mv.visitInsn(opcode);
                    this.mv.visitInsn(12);
                    this.mv.visitInsn(102);
                    this.mv.visitInsn(91);
                    this.mv.visitInsn(81);
                    break;
                }
                this.mv.visitInsn(opcode);
                break;
            }
            case 47: {
                if (this.shouldMutate("Decremented (--a) long array field")) {
                    this.mv.visitInsn(92);
                    this.mv.visitInsn(opcode);
                    this.mv.visitInsn(10);
                    this.mv.visitInsn(101);
                    this.mv.visitInsn(94);
                    this.mv.visitInsn(80);
                    break;
                }
                this.mv.visitInsn(opcode);
                break;
            }
            case 49: {
                if (this.shouldMutate("Decremented (--a) double array field")) {
                    this.mv.visitInsn(92);
                    this.mv.visitInsn(opcode);
                    this.mv.visitInsn(15);
                    this.mv.visitInsn(103);
                    this.mv.visitInsn(94);
                    this.mv.visitInsn(82);
                    break;
                }
                this.mv.visitInsn(opcode);
                break;
            }
            case 51: {
                if (this.shouldMutate("Decremented (--a) byte array field")) {
                    this.mv.visitInsn(92);
                    this.mv.visitInsn(opcode);
                    this.mv.visitInsn(4);
                    this.mv.visitInsn(100);
                    this.mv.visitInsn(145);
                    this.mv.visitInsn(91);
                    this.mv.visitInsn(84);
                    break;
                }
                this.mv.visitInsn(opcode);
                break;
            }
            case 53: {
                if (this.shouldMutate("Decremented (--a) short array field")) {
                    this.mv.visitInsn(92);
                    this.mv.visitInsn(opcode);
                    this.mv.visitInsn(4);
                    this.mv.visitInsn(100);
                    this.mv.visitInsn(147);
                    this.mv.visitInsn(91);
                    this.mv.visitInsn(86);
                    break;
                }
                this.mv.visitInsn(opcode);
                break;
            }
            default: {
                this.mv.visitInsn(opcode);
            }
        }
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        if (opcode == 180) {
            if (desc.equals("I") && this.shouldMutate("Decremented (--a) integer field")) {
                this.mv.visitInsn(89);
                this.mv.visitFieldInsn(opcode, owner, name, desc);
                this.mv.visitInsn(4);
                this.mv.visitInsn(100);
                this.mv.visitInsn(90);
                this.mv.visitFieldInsn(181, owner, name, desc);
                return;
            }
            if (desc.equals("F") && this.shouldMutate("Decremented (--a) float field")) {
                this.mv.visitInsn(89);
                this.mv.visitFieldInsn(opcode, owner, name, desc);
                this.mv.visitInsn(12);
                this.mv.visitInsn(102);
                this.mv.visitInsn(90);
                this.mv.visitFieldInsn(181, owner, name, desc);
                return;
            }
            if (desc.equals("J") && this.shouldMutate("Decremented (--a) long field")) {
                this.mv.visitInsn(89);
                this.mv.visitFieldInsn(opcode, owner, name, desc);
                this.mv.visitInsn(10);
                this.mv.visitInsn(101);
                this.mv.visitInsn(93);
                this.mv.visitFieldInsn(181, owner, name, desc);
                return;
            }
            if (desc.equals("D") && this.shouldMutate("Decremented (--a) double field")) {
                this.mv.visitInsn(89);
                this.mv.visitFieldInsn(opcode, owner, name, desc);
                this.mv.visitInsn(15);
                this.mv.visitInsn(103);
                this.mv.visitInsn(93);
                this.mv.visitFieldInsn(181, owner, name, desc);
                return;
            }
            if (desc.equals("B") && this.shouldMutate("Decremented (--a) double field")) {
                this.mv.visitInsn(89);
                this.mv.visitFieldInsn(opcode, owner, name, desc);
                this.mv.visitInsn(4);
                this.mv.visitInsn(100);
                this.mv.visitInsn(145);
                this.mv.visitInsn(90);
                this.mv.visitFieldInsn(181, owner, name, desc);
                return;
            }
            if (desc.equals("S") && this.shouldMutate("Decremented (--a) short field")) {
                this.mv.visitInsn(89);
                this.mv.visitFieldInsn(opcode, owner, name, desc);
                this.mv.visitInsn(4);
                this.mv.visitInsn(100);
                this.mv.visitInsn(147);
                this.mv.visitInsn(90);
                this.mv.visitFieldInsn(181, owner, name, desc);
                return;
            }
        }
        if (opcode == 178) {
            if (desc.equals("I") && this.shouldMutate("Decremented (--a) static integer field")) {
                this.mv.visitFieldInsn(opcode, owner, name, desc);
                this.mv.visitInsn(4);
                this.mv.visitInsn(100);
                this.mv.visitInsn(89);
                this.mv.visitFieldInsn(179, owner, name, desc);
                return;
            }
            if (desc.equals("F") && this.shouldMutate("Decremented (--a) static float field")) {
                this.mv.visitFieldInsn(opcode, owner, name, desc);
                this.mv.visitInsn(12);
                this.mv.visitInsn(102);
                this.mv.visitInsn(89);
                this.mv.visitFieldInsn(179, owner, name, desc);
                return;
            }
            if (desc.equals("J") && this.shouldMutate("Decremented (--a) static long field")) {
                this.mv.visitFieldInsn(opcode, owner, name, desc);
                this.mv.visitInsn(10);
                this.mv.visitInsn(101);
                this.mv.visitInsn(92);
                this.mv.visitFieldInsn(179, owner, name, desc);
                return;
            }
            if (desc.equals("D") && this.shouldMutate("Decremented (--a) static double field")) {
                this.mv.visitFieldInsn(opcode, owner, name, desc);
                this.mv.visitInsn(15);
                this.mv.visitInsn(103);
                this.mv.visitInsn(92);
                this.mv.visitFieldInsn(179, owner, name, desc);
                return;
            }
            if (desc.equals("B") && this.shouldMutate("Decremented (--a) static byte field")) {
                this.mv.visitFieldInsn(opcode, owner, name, desc);
                this.mv.visitInsn(4);
                this.mv.visitInsn(100);
                this.mv.visitInsn(145);
                this.mv.visitInsn(89);
                this.mv.visitFieldInsn(179, owner, name, desc);
                return;
            }
            if (desc.equals("S") && this.shouldMutate("Decremented (--a) static short field")) {
                this.mv.visitFieldInsn(opcode, owner, name, desc);
                this.mv.visitInsn(4);
                this.mv.visitInsn(100);
                this.mv.visitInsn(147);
                this.mv.visitInsn(89);
                this.mv.visitFieldInsn(179, owner, name, desc);
                return;
            }
        }
        this.mv.visitFieldInsn(opcode, owner, name, desc);
    }
}

