/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.testapi.execute.containers;

import java.util.Collection;
import org.pitest.testapi.Description;
import org.pitest.testapi.ResultCollector;
import org.pitest.testapi.TestResult;
import org.pitest.testapi.TestUnitState;

public final class ConcreteResultCollector
implements ResultCollector {
    private final Collection<TestResult> feedback;

    public ConcreteResultCollector(Collection<TestResult> feedback) {
        this.feedback = feedback;
    }

    @Override
    public void notifyStart(Description tu) {
        this.put(new TestResult(tu, null, TestUnitState.STARTED));
    }

    @Override
    public void notifySkipped(Description tu) {
        this.put(new TestResult(tu, null, TestUnitState.NOT_RUN));
    }

    @Override
    public void notifyEnd(Description description, Throwable t) {
        this.put(new TestResult(description, t));
    }

    @Override
    public void notifyEnd(Description description) {
        this.put(new TestResult(description, null));
    }

    private void put(TestResult tr) {
        this.feedback.add(tr);
    }

    @Override
    public boolean shouldExit() {
        return false;
    }
}

